function [ModelIn,ModelOut]=PARAFAC2b(ModelIn,ModelOut)
%
% This function is used to build a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
%  
% update, 24.07.2011: at evilin call, remove the "end" word -- By A.B.Spanier
%
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

warning off

global ModelIn ModelOut X 

ModelOut.validation =[];

GuiNames

if ndims(X{1})>2
    
    [ModelIn,ModelOut]= parafac2check(ModelIn,ModelOut);
    
    ModelIn.data.dataparafac2=X{1}.data;
    ModelIn.options.algorithm.name = 'PARAFAC 2';
    ModelOut.modelname = 'PARAFAC2';
    ModelIn.options.algorithm.constants(1)=0.0000001;
    ModelIn.options.algorithm.constants(2)=2000;
    ModelIn.options.algorithm.constants(3)=1;
    ModelIn.options.algorithm.constants(5)=0;
    ModelIn.options.constraints(1)=0;
    ModelIn.options.constraints(2)=0;
    %%% Window to input parameters of PARAFAC2
    h       = CenWindow(WIC,'PARAFAC 2 Model',[],385,238);
    set(gca,off{:})
    Tools = uimenu(la,'&Tools');
    FacTT  = ['Minimum and maximum number of factors',char(10),'separated by a coma: e.g. 3,5'];
    Opt   = uimenu(la,'&Preferences');
    Help  = uimenu(la,'&Help');
    uimenu(Help, la,'&About PARAFAC 2',cb,'AboutPARAFAC2')
    uimenu(Help, la,'&Help',tg,'Help',cb,'Help1')
    uimenu(Opt,la,'&Algorithm options',cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Options(ModelIn,ModelOut);',tg,'Parafac2Opt');
    
    ModelIn.nbfactors.min=3;   %% Default value for the number of factors
    ValMet = strcmp({'loo','nboo','test','oth'},ModelIn.valmethod.name);
    Segm   = sprintf('%i',ModelIn.valmethod.segments);
    Repl   = sprintf('%i',ModelIn.valmethod.replicates);
    uicontrol(ty,tx,pos,[ 10 196  80  25],st,'Factors',bg,WIC,ari{:}); 
    CVHan.facted   = uicontrol(gcf,ty,ed,pos,[105 198 130  30],'string',int2str(ModelIn.nbfactors.min),cb,'global ModelIn ModelOut;evalin(''caller'',''ModelIn.nbfactors.min=eval(get(gcbo,''''string''''));'');,ModelIn.nbfactors.max=ModelIn.nbfactors.min;end;',tg,'Factors',bg,wh,ari{:},tt,FacTT);
    
    uicontrol(ty,ps,pos,[245  46 130  30],st,'Cancel', cb,'close',tg,'End', ari{:});
    uicontrol(ty,fr,pos,[10 10 225 180], bg,FRC);
    CVHan.meth(1)  = uicontrol(gcf,ty,rb,pos,[20 150 150  30],st,'No Cross Validation', cb,'truc1 = get(gcbo,''value''); if truc1==1,ModelIn.options.algorithm.constants(4)=0,ModelOut.validation=[],ModelIn.valmethod.name=''no_cross_validation'',set([findobj(''tag'',''CV''),findobj(''tag'',''7S'')],''enable'',''off'');else,set([findobj(''tag'',''CV''),findobj(''tag'',''7S'')],''enable'',''on'');end;',tg,'NOCV',bg,FRC,ari{:},tt,'No Cross Validation',en{:},va,1);
    CVHan.meth(2)  = uicontrol(gcf,ty,rb,pos,[20 100 200  30],st,'Cross Validation splitting', cb,'truc3 = get(gcbo,''value''); if truc3==1,ModelIn.options.algorithm.constants(4)=1,ModelOut.validation=1,ModelIn.valmethod.name=''cross_validation'',set([findobj(''tag'',''NOCV'')],''enable'',''off'');else,set([findobj(''tag'',''NOCV'')],''enable'',''on'');end',tg,'CV', bg,FRC,ari{:},en{:});
    uicontrol(gcf,ty,tx,pos,[20 75 140 30],st,'in 7 segments',bg,FRC,tg,'7S',ari{:},en{:});
    
    CVHan.stbutton = uicontrol(gcf,ty,ps,pos,[245  10 130  30],st,'Start ', cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Model(ModelIn,ModelOut);',tg,'StartBut',ari{:});
    CVHan.prepro   = uicontrol(gcf,ty,ps,pos,[245 198 130  30],st,'Preprocessing',tg,'PreTreat', ari{:},dis{:});
    CVHan.const    = uicontrol(gcf,ty,ps,pos,[245 162 130  30],st,'Set Constraints', cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Constraints(ModelIn,ModelOut);',tg,'Const', ari{:});
    
    waitfor(h,'waitstatus','close')
    
    [ModelIn,ModelOut]=parafac2activateplots(ModelIn,ModelOut,X);
    
else
    
    
    
    [nexp,inutile]=size(ModelIn.file.matrices);
    
    ModelIn.options.algorithm.name = 'PARAFAC 2';
    ModelOut.modelname = 'PARAFAC2';
    
    ModelIn.options.algorithm.constants(1)=0.0000001;
    ModelIn.options.algorithm.constants(2)=2000;
    ModelIn.options.algorithm.constants(3)=1;
    ModelIn.options.algorithm.constants(5)=0;
    ModelIn.options.constraints(1)=0;
    ModelIn.options.constraints(2)=0;
    
    %Initialisations
    seb{1}=ModelOut.data.dataset(1:ModelIn.file.size(1),:);
    seb{1}=seb{1}';
    a=1;
    b=ModelIn.file.size(1);
    
    % Construction of the matrix with cell for parafac2
    for i=2:nexp
        seb{i}=ModelOut.data.dataset(a+ModelIn.file.size(i-1):b+ModelIn.file.size(i),:);
        seb{i}=seb{i}';
        a=a+ModelIn.file.size(i-1);
        b=b+ModelIn.file.size(i);
    end
    ModelIn.data.dataparafac2=seb;
    
    
    %%%% Window to input parameters of PARAFAC2
    h       = CenWindow(WIC,'PARAFAC 2 Model',[],385,238);
    set(gca,off{:})
    Tools = uimenu(la,'&Tools');
    FacTT  = ['Minimum and maximum number of factors',char(10),'separated by a coma: e.g. 3,5'];
    Opt   = uimenu(la,'&Preferences');
    Help  = uimenu(la,'&Help');
    uimenu(Help, la,'&About PARAFAC 2',cb,'AboutPARAFAC2')
    uimenu(Help, la,'&Help',tg,'Help',cb,'Help1')
    uimenu(Opt,la,'&Algorithm options',cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Options(ModelIn,ModelOut);',tg,'Parafac2Opt');
     
    ModelIn.nbfactors.min=3;   %% Default value for the number of factors - added 07/01/03 - Asked by EDC
    ValMet = strcmp({'loo','nboo','test','oth'},ModelIn.valmethod.name);
    Segm   = sprintf('%i',ModelIn.valmethod.segments);
    Repl   = sprintf('%i',ModelIn.valmethod.replicates);
    uicontrol(ty,tx,pos,[ 10 196  80  25],st,'Factors',bg,WIC,ari{:}); 
    
    % Cu_FIX_2011 (remove the word 'end')
    % orig: CVHan.facted   = uicontrol(gcf,ty,ed,pos,[105 198 130  30],'string',int2str(ModelIn.nbfactors.min),cb,'global ModelIn ModelOut;evalin(''caller'',''ModelIn.nbfactors.min=eval(get(gcbo,''''string''''));'');ModelIn.nbfactors.max=ModelIn.nbfactors.min;end;',tg,'Factors',bg,wh,ari{:},tt,FacTT);
    
    CVHan.facted   = uicontrol(gcf,ty,ed,pos,[105 198 130  30],'string',int2str(ModelIn.nbfactors.min),cb,'global ModelIn ModelOut;evalin(''caller'',''ModelIn.nbfactors.min=eval(get(gcbo,''''string''''));'');ModelIn.nbfactors.max=ModelIn.nbfactors.min;',tg,'Factors',bg,wh,ari{:},tt,FacTT); 
    
    uicontrol(ty,ps,pos,[245  46 130  30],st,'Cancel', cb,'close;',tg,'End', ari{:});
    uicontrol(ty,fr,pos,[10 10 225 180], bg,FRC);
    CVHan.meth(1)  = uicontrol(gcf,ty,rb,pos,[20 150 150  30],st,'No Cross Validation', cb,'truc1 = get(gcbo,''value''); if truc1==1,ModelIn.options.algorithm.constants(4)=0,ModelOut.validation=[],ModelIn.valmethod.name=''no_cross_validation'',set([findobj(''tag'',''CV''),findobj(''tag'',''7S'')],''enable'',''off'');else,set([findobj(''tag'',''CV''),findobj(''tag'',''7S'')],''enable'',''on'');end;',tg,'NOCV',bg,FRC,ari{:},tt,'No Cross Validation',en{:},va,1);
    CVHan.meth(2)  = uicontrol(gcf,ty,rb,pos,[20 100 200  30],st,'Cross Validation splitting', cb,'truc3 = get(gcbo,''value''); if truc3==1,ModelIn.options.algorithm.constants(4)=1,ModelOut.validation=1,ModelIn.valmethod.name=''cross_validation'',set([findobj(''tag'',''NOCV'')],''enable'',''off'');else,set([findobj(''tag'',''NOCV'')],''enable'',''on'');end',tg,'CV', bg,FRC,ari{:},en{:});
    uicontrol(gcf,ty,tx,pos,[20 75 140 30],st,'in 7 segments',bg,FRC,tg,'7S',ari{:},en{:});
    
    CVHan.stbutton = uicontrol(gcf,ty,ps,pos,[245  10 130  30],st,'Start ', cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Model(ModelIn,ModelOut);',tg,'StartBut',ari{:});
    CVHan.prepro   = uicontrol(gcf,ty,ps,pos,[245 198 130  30],st,'Preprocessing',tg,'PreTreat', ari{:},dis{:});
    CVHan.const    = uicontrol(gcf,ty,ps,pos,[245 162 130  30],st,'Set Constraints', cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=PARAFAC2Constraints(ModelIn,ModelOut);',tg,'Const', ari{:});
    
    waitfor(h,'waitstatus','close')
    
    [ModelIn,ModelOut]=parafac2activateplots(ModelIn,ModelOut,X);
    
    warning on
    
end
