function [ModelIn,ModelOut]=parafac2activateplots(ModelIn,ModelOut,X)
%
% This function activates the plot menu for PARAFAC2
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

guinames

if isempty(ModelOut.prediction.data)
    %construction of the Resultsuimenu 
    h0=findobj('tag','res');
    delete(allchild(h0));
    set(h0,'enable','on');
    
    X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
    X=X{1}.data;
    N=ndims(X);
    
    wpi=cell(1:N);
    
    if iscell(ModelIn.data.dataparafac2)
        N=3;
    else
        N=ndims(X);
    end
    
    for i=1:N,
        wpi{i}=['PlotStr.nummode=',int2str(i),';'];
        nom=['Mode ',int2str(i)];
        
        
        h1 = uimenu('Parent',h0, ...
            'Label',nom);
        for j=1:3,
            wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
            wp2=['PlotStr.plotdims=',int2str(j),';'];
            wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
            wp4=['parafac2plot(''gra'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
            nom=[int2str(j),'-D plots'];
            tg=['plotd',int2str(j),int2str(i)];
            h2 = uimenu('Parent',h1,'Callback',[wp1,wpi{i},wp2,wp3,wp4],'Label',nom,'Tag',tg);
        end;
        
        if ModelIn.nbfactors.min<3,
            set(findobj('tag',['plotd3',int2str(i)]),'enable','off');
            if ModelIn.nbfactors.min<2,
                set(findobj('tag',['plotd2',int2str(i)]),'enable','off');
                if ModelIn.nbfactors.min<1,
                    set(findobj('tag',['plotd1',int2str(i)]),'enable','off');
                end;
            end;
        end;
    end;
    h1 = uimenu('Parent',h0,'tag','mm','Label','Mixed modes',dis{:});
    wpi=cell(N,N);
    for i=1:N,
        for j=i+1:N,
            nom=['Modes ',int2str(i),'*',int2str(j)];
            h2 = uimenu('Parent',h1,'Label',nom);
            wpi{i,j}=['global ModelIn ModelOut;PlotStr.nummode=[',int2str(i),',',int2str(j),'];'];
            for k=1:3,
                wp1='global ModelIn ModelOut;PlotStr=getappdata(gcbf,''PlotStr'');';
                wp2=['global ModelIn ModelOut;PlotStr.plotdims=',int2str(k),';'];
                wp3='global ModelIn ModelOut;setappdata(gcbf,''PlotStr'',PlotStr);';
                wp4=['global ModelIn ModelOut;parafac2plot(''gra'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
                nom=[int2str(k),'-D plots'];
                tg=['plotd',int2str(k),int2str(i),int2str(j)];
                h3 = uimenu('Parent',h2,'Callback',[wp1,wpi{i,j},wp2,wp3,wp4],'Label',nom,'Tag',tg);
            end;
        end;
    end;
    if min(ModelIn.nbfactors.min)<1,
        set(findobj('tag','mm'),'enable','off');
    end;
    h1 = uimenu('Parent',h0, ...
        'Label','Explained Variation', ...
        'enable','off',...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''exv'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));',...
        'Tag','Exp Var');
    h1 = uimenu('Parent',h0, ...
        'Label','Model (landscape)', ...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''xmo'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));',...
        'Tag','mod');
    h1 = uimenu('Parent',h0, ...
        'Label','Residuals', ...
        'separator','on',...
        'enable','on',...
        'Tag','resi');
    h2 = uimenu('Parent',h1, ...
        'Label','For individual samples', ...
        'enable','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''res'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','resiind');
    h2 = uimenu('Parent',h1, ...
        'Label','For all samples (landscape)', ...
        'separator','on',...
        'enable','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''all'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','allresi');
    if size(ModelIn.data.dataparafac2)>2
        set(findobj('tag','allresi'),'enable','off')
    end
    h2 = uimenu('Parent',h1, ...
        'Label','For individual batches (landscape)', ...
        'enable','on',...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''bat'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','resiindbat');
    
    set(ModelIn.xpointer,'waitstatus','close');  
    return
    %-------------------------------------------------------------
else
    
    %construction of the Resultsuimenu 
    h0=findobj('tag','res');
    delete(allchild(h0));
    set(h0,'enable','on');
    
    X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
    X=X{1}.data;
    N=ndims(X);
    
    wpi=cell(1:N);
    
    if iscell(ModelIn.data.dataparafac2)
        N=3;
    else
        N=ndims(X);
    end
    
    for i=1:N,
        wpi{i}=['PlotStr.nummode=',int2str(i),';'];
        nom=['Mode ',int2str(i)];
        
        h1 = uimenu('Parent',h0, ...
            'Label',nom);
        for j=1:3,
            wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
            wp2=['PlotStr.plotdims=',int2str(j),';'];
            wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
            wp4=['parafac2plot(''gra'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
            nom=[int2str(j),'-D plots'];
            tg=['plotd',int2str(j),int2str(i)];
            h2 = uimenu('Parent',h1,'Callback',[wp1,wpi{i},wp2,wp3,wp4],'Label',nom,'Tag',tg);
        end;
        if ModelIn.nbfactors.min<3,
            set(findobj('tag',['plotd3',int2str(i)]),'enable','off');
            if ModelIn.nbfactors.min<2,
                set(findobj('tag',['plotd2',int2str(i)]),'enable','off');
                if ModelIn.nbfactors.min<1,
                    set(findobj('tag',['plotd1',int2str(i)]),'enable','off');
                end;
            end;
        end;
    end;
    h1 = uimenu('Parent',h0,'tag','mm','Label','Mixed modes',dis{:});
    wpi=cell(N,N);
    for i=1:N,
        for j=i+1:N,
            nom=['Modes ',int2str(i),'*',int2str(j)];
            h2 = uimenu('Parent',h1,'Label',nom);
            wpi{i,j}=['global ModelIn ModelOut;PlotStr.nummode=[',int2str(i),',',int2str(j),'];'];
            for k=1:3,
                wp1='global ModelIn ModelOut;PlotStr=getappdata(gcbf,''PlotStr'');';
                wp2=['global ModelIn ModelOut;PlotStr.plotdims=',int2str(k),';'];
                wp3='global ModelIn ModelOut;setappdata(gcbf,''PlotStr'',PlotStr);';
                wp4=['global ModelIn ModelOut;parafac2plot(''gra'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
                nom=[int2str(k),'-D plots'];
                tg=['plotd',int2str(k),int2str(i),int2str(j)];
                h3 = uimenu('Parent',h2,'Callback',[wp1,wpi{i,j},wp2,wp3,wp4],'Label',nom,'Tag',tg);
            end;
        end;
    end;
    if min(ModelIn.nbfactors.min)<1,
        set(findobj('tag','mm'),'enable','off');
    end;
    h1 = uimenu('Parent',h0, ...
        'Label','Explained Variation', ...
        'enable','off',...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''exv'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));',...
        'Tag','Exp Var');
    h1 = uimenu('Parent',h0, ...
        'Label','Model', ...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''xmo'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));',...
        'Tag','xmo');
    h1 = uimenu('Parent',h0, ...
        'Label','Residuals', ...
        'separator','on',...
        'enable','on',...
        'Tag','resi');
    h2 = uimenu('Parent',h1, ...
        'Label','For individual samples', ...
        'enable','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''ind'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','resiind');
    h2 = uimenu('Parent',h1, ...
        'Label','For all samples', ...
        'separator','on',...
        'enable','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''all'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','allresi');
    if size(ModelIn.data.dataparafac2)>2
        set(findobj('tag','allresi'),'enable','off')
    end
    h2 = uimenu('Parent',h1, ...
        'Label','For individual batches', ...
        'enable','on',...
        'separator','on',...
        'callback','global ModelIn ModelOut;parafac2plot(''bat'',[],getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''X''));',...
        'Tag','resiindbat');
    if ndims(ModelOut.prediction.data.data)==2
        set(findobj('tag','resiindbat'),'enable','off')
    end
    set(ModelIn.xpointer,'waitstatus','close');  
    return
    
end
