function PARAFAC2Report(MainFig,ReportStruct,Fil_id)

% function PARAFA2CReport (MainFig,ReportStruct,Fil_id);
% 
% Description:
% Handles the report for the Model/Validation/Projection parts when the current model (i.e. the model
% saved in the 'Results' application-defined data of the main figure) is a PARAFAC2 model. The parts to
% report are defined in the ReportStruct structure, which is passed by the calling function.
% 
% Inputs: 
% MainFig     : handle to the main figure
% ReportStruct: ReportStruct structure, with flags relative to which information should be saved in the
%               .txt file
% Fil_id      : handle to the .txt file
%  
% Outputs:
% None
%  
% 
% Called by:
% SaveReport
% 
% Subroutines:
% Internal: None
% External: getcvdata
% 
% 
% Author: 
% Sbastien Gourvnec 
% FABI
% Vrije Universiteit Brussel (VUB)
% Laarbeeklaan 103 
% 1090 Brussels
% Belgium 
% 
% Last modified: 24-Jan-2003
% 
% Contact: Sbastien Gourvnec, sgourven@vub.ac.be 
%


ModelOut = getcvdata(MainFig,'Results');
ModelIn  = getcvdata(MainFig,'Model');

if any(ReportStruct.m_info)
    
    %Model info and name
    fwrite(Fil_id,[10 'Model               : PARAFAC 2' 10],'char');
    fwrite(Fil_id,['Number of factors   :'],                    'char');
    fwrite(Fil_id,[sprintf(' %i',[size(ModelOut.model.xfactors{1},2)]),10],'char');
    fwrite(Fil_id,['Explained variance  : '],'char');
    fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut.model.xev),10, 10],  'char');
    %Preprocessing. NB the different scalings are not distinguished
    fwrite(Fil_id,[   'Preprocessing'                 10],'char');
    fwrite(Fil_id,[   'Centring            : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.cen);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    fwrite(Fil_id,[   'Scaling             : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.scal);
    fwrite(Fil_id,[int2str(~a(:)') 10 10],'char');
    
    %Algorithm information
    fwrite(Fil_id,[10,'Algorithm               :  '],'char');
    fwrite(Fil_id,[ModelOut.info.algorithm 10],'char');
    fwrite(Fil_id,['Iterations              : '],                             'char');
    fwrite(Fil_id,[sprintf(' %i',[ModelOut.info.maxiter]), 10],'char');
    fwrite(Fil_id,['Convergence criterion   : '],              'char');
    fwrite(Fil_id,[sprintf(' %i',[ModelOut.info.convcrit]), 10, 10],'char');
    
    %Constraints
    fwrite(Fil_id,['Constraints'                   10],'char');
    fwrite(Fil_id,['-----------------' 10],'char');
    
    %Model
    fwrite(Fil_id,[10,'Model (PARAFAC2)' 10, 10],'char');
    
    fwrite(Fil_id,['Loadings Mode 1 :'                          10],'char');
    if size(ModelOut.model.xfactors{1},1)>10
        Mat = num2str(ModelOut.model.xfactors{1}(1:10,:));
    else
        Mat = num2str(ModelOut.model.xfactors{1}(1:size(ModelOut.model.xfactors{1},1),:));
    end
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
    
    fwrite(Fil_id,['Loadings Mode 2 - slice 1 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{2}{1}*ModelOut.model.core);   
    if size(Mat,1)>10
        Mat = Mat(1:10,:);
    else
        Mat = Mat(1:size(Mat,1),:);
    end
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
    
    fwrite(Fil_id,['Loadings Mode 3 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{3});
    if size(Mat,1)>10
        Mat= Mat(1:10,:);
    else
        Mat=Mat(1:size(Mat,1),:);
    end
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
end
