function Predictions = PARAFAC2Pred(X,Model_Parameters,varargin)
%
% This function is used to make predictions drom a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

if isa(Model_Parameters,'struct')
   F                = Model_Parameters.nbfactors;
   Model_Parameters = Model_Parameters.xfactors;
else
   F = size(Model_Parameters{1},2);
end
Ain                  = zeros(size(X,1),F);
[varargin{3:4}]      = deal([{Ain},Model_Parameters(2:end)],[0 ones(1,ndims(X)-1)]);
Factors              = parafac(X,F,varargin{:});
Predictions.xpred    = nmodel(Factors);
Predictions.xfactors = Factors{1};