function [ModelIn,ModelOut]=PARAFAC2Options(ModelIn,ModelOut);
%
% This function is used to set options of a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be


GuiNames

global ModelIn ModelOut

h   = CenWindow(WIC,'PARAFAC 2 Options',[],490,217);
set(h,'toolbar','none')
Han(15) = uicontrol(ty,fr,pos,[7 6 336 206],bg,FRC);

%Initialsation
InitSt  = {'best','SVD','random'};
Han(1)  = uicontrol(ty,tx,pos,[ 10 179 100  25],st,'Initialisation',ari{:},bg,FRC,bd{:},ha,'left');
Han(2)  = uicontrol(ty,pu,pos,[110 177 130  30],st,InitSt,cb,'ModelIn.options.algorithm.constants(3) = get(gcbo,''value'');',ari{:},tg,'initialise',bg,'w',ud,4);

%Convergence criteria
Han(3)  = uicontrol(ty,tx,pos,[ 10 145 200  25],st,'Convergence criterion',ari{:},bg,FRC,bd{:},ha,'left');
Han(4)  = uicontrol(ty,tx,pos,[ 10 116 100  25],st,'Fit',bg,FRC,ari{:});
Han(5)  = uicontrol(ty,ed,pos,[110 114  60  30],st,sprintf('%1.0e',ModelIn.options.algorithm.constants(1)),cb,'ModelIn.options.algorithm.constants(1) = sscanf(get(gcbo,''string''),''%g'');',ari{:},bg,'w',tg,'convcrit',ud,1);

%Max iter
Han(10) = uicontrol(ty,tx,pos,[ 10  64 130  25],st,'Iteration limits',bg,FRC,ari{:},bd{:},ha,'left');
Han(11) = uicontrol(ty,tx,pos,[ 10 35 100 25],st,'Init. Max. Iter',ari{:},bg,FRC);
Han1(12) = uicontrol(ty,ed,pos,[110 35  50 30],st,sprintf('%i',ModelIn.options.algorithm.constants(2)),ari{:},cb,'ModelIn.options.algorithm.constants(2) = sscanf(get(gcbo,''string''),''%g'');',bg,'w',tg,'maxiter',ud,3);

Han(17) = uicontrol(ty,ps,pos,[350  46 130  30],st,'Cancel',cb,'close gcf;',tg,'end main',ari{:});
Han(18) = uicontrol(ty,ps,pos,[350  10 130  30],st,'OK',cb,'ModelIn.options.algorithm.constants;close gcf',tg,'ok',ari{:});

set(h,'waitstatus','close')

