function [ModelIn,ModelOut]=PARAFAC2Model(ModelIn,ModelOut)
%
% This function is used to build a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Update 24.07.2011 remove the global ModelIn ModelOut; defintion 
%       -- we get it from argvin already. -- AB.Spanier 
%
%
%
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

% global ModelIn ModelOut;

ModelOut.prediction.data = [];


if ModelIn.options.algorithm.constants(3)~=0
    ModelIn.options.algorithm.constants(3)=ModelIn.options.algorithm.constants(3)-1;
end

if ModelIn.options.constraints(1)==0;ModelIn.options.constraints(1)=1;end
if ModelIn.options.constraints(2)==0;ModelIn.options.constraints(2)=1;end

ModelIn.options.constraints(1)=ModelIn.options.constraints(1)-1;
ModelIn.options.constraints(2)=ModelIn.options.constraints(2)-1;

% To hide all outputs on screen
ModelIn.options.algorithm.constants(5)=1;
%

%
% call the N-way toolbox!
%
[ModelOut.model.xfactors{1} , ModelOut.model.core,ModelOut.model.xfactors{3} , ...
    ModelOut.model.xfactors{2} , ModelOut.model.xev]= ...
       parafac2(ModelIn.data.dataparafac2, ModelIn.nbfactors.min , ...
       [(ModelIn.options.constraints(1)) (ModelIn.options.constraints(2))] , ...
           ModelIn.options.algorithm.constants);

if size(ModelIn.data.dataparafac2)>2
    for k=1:size(ModelIn.data.dataparafac2,3)
        Xrecons{k}=((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
    end
    
    for k=1:size(ModelIn.data.dataparafac2,3)
        E{k}=ModelIn.data.dataparafac2(:,:,k)-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
    end
    
    for k=1:size(ModelIn.data.dataparafac2,3)
        normE(k)=norm(E{k},'fro')^2;
        normX(k)=norm(Xrecons{k},'fro')^2;
    end
    
    ModelOut.model.nbfactors=ModelIn.nbfactors.min;
    
    if ModelIn.options.algorithm.constants(3)==0
        ModelOut.info.algorithm='Best';
    else
        if ModelIn.options.algorithm.constants(3)==1
            ModelOut.info.algorithm='SVD';
        else
            ModelOut.info.algorithm='Random';
        end
    end
    
    ModelOut.info.convcrit=ModelIn.options.algorithm.constants(1);
    ModelOut.info.maxiter=ModelIn.options.algorithm.constants(2);
    
    ModelOut.model.xev=(1-(sum(normE)/sum(normX)))*100;
    
    PARAFAC2DisplayInfo(gcbf,ModelOut);
    
    ModelOut.options=ModelIn.options;
    close
    
else
    
    
    for k=1:size(ModelIn.data.dataparafac2,2)
        Xrecons{k}=((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
    end
    
    for k=1:size(ModelIn.data.dataparafac2,2)
        E{k}=ModelIn.data.dataparafac2{k}-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
    end
    
    for k=1:size(ModelIn.data.dataparafac2,2)
        normE(k)=norm(E{k},'fro')^2;
        normX(k)=norm(Xrecons{k},'fro')^2;
    end
    
    ModelOut.model.nbfactors=ModelIn.nbfactors.min;
    
    if ModelIn.options.algorithm.constants(3)==0
        ModelOut.info.algorithm='Best';
    else
        if ModelIn.options.algorithm.constants(3)==1
            ModelOut.info.algorithm='SVD';
        else
            ModelOut.info.algorithm='Random';
        end
    end
    
    ModelOut.info.convcrit=ModelIn.options.algorithm.constants(1);
    ModelOut.info.maxiter=ModelIn.options.algorithm.constants(2);
    
    ModelOut.model.xev=(1-(sum(normE)/sum(normX)))*100;
    
    PARAFAC2DisplayInfo(gcbf,ModelOut);
    
    ModelOut.options=ModelIn.options;
    
    close
end



