function DisplayInfo(MainFig,ModelOut)
%
% This function displays info about a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be


GuiNames

if isempty(ModelOut.prediction.data)
    
    X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
    
    delete(findobj(tg,'textfig'))
    if ~isa(X,'cell')
        X = {X};
    end
    DisplayInfo(MainFig,X);
    fnor = {'fontunits','normalized'};
    vert = {'verticalalignment','cap'};
    
    a    = findobj(tg,'textfig');
    apos = get(a,'extent');
    if isa(apos,'cell')
        apos = min(cat(1,apos{:}));
    end
    b     = text(.5,apos(2) - 0.05,'\bf\fontsize{12}Model: PARAFAC 2',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
    bpos  = get(b,'extent');
    S2a   = {'\fontsize{10}Algorithm';'N. of factors';'Expl. Var.';'Centering';'Scaling';'Conv. Crit.';'Max. Iter.'};
    
    Alg =[ModelOut.info.algorithm];
    
    if length(ModelOut.model) ~= 1
        NbFacStr = sprintf('%i - %i',ModelOut.model(1).nbfactors,ModelOut.model(end).nbfactors);
        EVStr    = [];
    else
        NbFacStr = int2str(ModelOut.model.nbfactors);
        EVStr    = sprintf('%0.5g',ModelOut.model.xev);
    end
    
    if ~isempty(ModelOut.model.xpreproc.cen(:))
        PreTrStrA = [ModelOut.model.xpreproc.cen(:)];
    else
        PreTrStrA=0;
    end
    if ~isempty(ModelOut.model.xpreproc.scal(:))
        PreTrStrB = [ModelOut.model.xpreproc.scal(:)];
    else
        PreTrStrB=0;
    end
    
    Convcrit=num2str(ModelOut.info.convcrit);
    Maxiter=num2str(ModelOut.info.maxiter);
    
    
    S2b = { [': ',Alg];...
            [': ',NbFacStr];...
            [': ',EVStr];...
            [': [ ',sprintf('%i ',PreTrStrA),']'];...
            [': [ ',sprintf('%i ',PreTrStrB),']'];...
            [': ',Convcrit];...
            [': ',Maxiter]};
    text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
    cpos = get(c,'extent');S30 = [];
    
    S3 = [];
    
    if ~isempty(S30)
        d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
        dpos  = get(d,'extent');
        text(.05,dpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
        e = text(.5,dpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
    end
    set(findobj(gcf,tg,'textfig'),'clipping','on')
    
    %--------------------------------------------
else
    
    X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
    
    delete(findobj(tg,'textfig'))
    if ~isa(X,'cell')
        X = {X};
    end
    DisplayInfo(MainFig,X);
    fnor = {'fontunits','normalized'};
    vert = {'verticalalignment','cap'};
    
    a    = findobj(tg,'textfig');
    apos = get(a,'extent');
    if isa(apos,'cell')
        apos = min(cat(1,apos{:}));
    end
    b     = text(.5,apos(2) - 0.05,'\bf\fontsize{12}Model: PARAFAC 2',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
    bpos  = get(b,'extent');
    S2a   = {'\fontsize{10}Algorithm';'N. of factors';'Expl. Var.';'Centering';'Scaling';'Conv. Crit.';'Max. Iter.'};
    
    Alg =[ModelOut.info.algorithm];
    
    if length(ModelOut.model) ~= 1
        NbFacStr = sprintf('%i - %i',ModelOut.model(1).nbfactors,ModelOut.model(end).nbfactors);
        EVStr    = [];
    else
        NbFacStr = int2str(ModelOut.model.nbfactors);
        EVStr    = sprintf('%0.5g',ModelOut.model.xev);
    end
    
    if ~isempty(ModelOut.model(1).xpreproc.cen(:))
        PreTrStrA = [ModelOut.model(1).xpreproc.cen(:)];
    else
        PreTrStrA=0;
    end
    if ~isempty(ModelOut.model(1).xpreproc.scal(:))
        PreTrStrB = [ModelOut.model(1).xpreproc.scal(:)];
    else
        PreTrStrB=0;
    end
    
    Convcrit=num2str(ModelOut.info.convcrit);
    Maxiter=num2str(ModelOut.info.maxiter);
    
    
    S2b = { [': ',Alg];...
            [': ',NbFacStr];...
            [': ',EVStr];...
            [': [ ',sprintf('%i ',PreTrStrA),']'];...
            [': [ ',sprintf('%i ',PreTrStrB),']'];...
            [': ',Convcrit];...
            [': ',Maxiter]};
    text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
    cpos = get(c,'extent');S30 = [];
    
    S3 = [];
    
    set(findobj(gcf,tg,'textfig'),'clipping','on')
    
    AxH = [];
    
    X=ModelOut.prediction.data;
    Type = {'Single set','Multiple Set'};
    S1a = {'\fontsize{10}Name';'Size';'Type';'Missing data'};
    NaNPerc = isnan(X.data);
    if strcmp(X.type,'Batch')
        Dims = ['--- ',int2str(X.dims(2:end))];
    else
        Dims = int2str(X.dims);      
    end
    S1b = {[': ',X.name]
        [': [',Dims,']']
        [': ',Type{find(strcmp({'Data','Batch'},X.type))}]
        num2str(100 * sum(NaNPerc(:)) / prod(size(NaNPerc)),': %3.2f %%')};
    fnor = {'fontunits','normalized'};
    vert = {'verticalalignment','cap'};
    
    d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}New Data X'],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
    dpos  = get(d,'extent');
    text(.05,dpos(2)-0.02,S1a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    e = text(.5,dpos(2)-0.02,S1b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
    
    if ~isempty(X.description) | ~isempty(X.author)
        c    = text(.5,bpos(2)-0.015,'\itClick here for more','verticalalignment','top',tg,'textfig',ha,'center','buttondownfcn','DisplayInfo(gcbf,gcbo);',ud,{X.description,X.author});
        bpos = get(c,'extent');
    end
    
end
