function [ModelIn,ModelOut]=PARAFAC2Constraints(ModelIn,ModelOut)
%
% This function is used to set PARAFAC2 constraints
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be


GuiNames

global ModelIn ModelOut;

Const = {'None','Non-negativity','Orthogonality','Unimodality'};
[a,Pos_Exist_Const] = intersect({ModelIn.constraints.name},lower(Const));
ConstStat = cat(1,ModelIn.constraints.modes);
bgc  = [0.5029 0.5814 0.6402];
fbg=[0.3529 0.4314 0.4902];
FrH  = 25 * (length(ModelIn.var(1).cen) + 1) + 56; 
h    = CenWindow(WIC,'PARAFAC 2 Constraints',[],430, FrH + 14);
Base = length(ModelIn.var(1).cen)* 25 + 10;
uicontrol(ty,fr,pos,[  7     7 276 FrH],bg,FRC)
if ~isempty(find(ConstStat(:,1)))
    a = find(Pos_Exist_Const == find(ConstStat(:,1)));
else
    a = 0;
end
if isempty(a)
    a = 0;
end
uicontrol(ty,pu,pos,[150 Base     130  25],st,Const,cb,'ModelIn.options.constraints(1) = get(gcbo,''value'');',tg,'Constraint',ari{:},bg,wh,va,a + 1,ud,1);
uicontrol(ty,tx,pos,[ 10 Base - 2 130  25],st,'Mode 1',ari{:},bg,fbg,ud,1)
for i = 1:length(ModelIn.var(1).cen)
    if ~isempty(find(ConstStat(:,1)))
        a = find(Pos_Exist_Const == find(ConstStat(:,i + 1)));
    else
        a = 0;
    end
    if isempty(a)
        a = 0;
    end
    uicontrol(ty,pu,pos,[150 Base - 25 * i     130 25],st,Const,cb,'ModelIn.options.constraints(2) = get(gcbo,''value'');',tg,'Constraint',ari{:},bg,wh,va,a + 1,ud,i + 1)
    uicontrol(ty,tx,pos,[ 10 Base - 25 * i - 2 130 25],st,'Mode 3',ari{:},bg,fbg,ud,i + 1)
end
uicontrol(ty,tx,pos,[10  Base + 50 270 25],st,'X',ha,'center',ari{:},bd{:},fs,13,bg,fbg)
uicontrol(ty,tx,pos,[150 Base + 25 130 25],st,'Constraint',ha,'center',ari{:},bd{:},fs,12,bg,fbg)
uicontrol(ty,tx,pos,[ 10 Base + 25 130 25],st,'Mode',ha,'center',ari{:},bd{:},fs,12,bg,fbg)
uicontrol(ty,ps,pos,[290        10 130 30],st,'OK',cb,'global ModelIn ModelOut;close',tg,'Ok',ari{:})
uicontrol(ty,ps,pos,[290        46 130 30],st,'Cancel',cb,'global ModelIn ModelOut;close',tg,'window',ari{:})
