
function [ModelIn,ModelOut]  = PARAFAC2Apply(ModelIn, ModelOut);
%
% This function applies a PARAFAC2 model
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

warning off

global ModelIn ModelOut X
Guinames

ListProp          = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
ReqTit            = 'Load data';
[Xt,Yt,Xfil,Yfil] = deal({});
[Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);
RankPos           = 1;
if Xfil{1} ~= 0
    Cont = who('-file',[Xfil{:}]);
    Ok   = 1;
    Sel  = 1;
    if length(Cont) > 1
        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    end
    if Ok
        
        if ndims(Xt)~=2
            
            
            Xt   = load([Xfil{:}],Cont{Sel});
            Xt   = getfield(Xt,Cont{Sel});
            if ~isempty(Xt)
                DimX = size(Xt);
                DimM = size(ModelOut.data.dataset);
                if DimX(2:end) ~= DimM(2:end)
                    errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
                    return
                end
            else
                return
            end
            
            if ~isa(Xt,'cbdataset')
                Ans = questdlg('Batch labels','Batches labels','Load','Default','Cancel','Load');
                if strcmp(Ans,'Load')
                    [Lafil{2:-1:1}] = uigetfile('*.mat','Load Y data');
                    Cont = who('-file',[Lafil{:}]);
                    Ok   = 1;
                    Sel  = 1;
                    if length(Cont) > 1
                        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
                    end
                    if Ok
                        Lat  = load([Lafil{:}],Cont{Sel});
                        Lat  = getfield(Lat,Cont{Sel});
                    else 
                        return
                    end
                elseif strcmp(Ans,'Cancel')
                    return
                else
                    Lat = [];
                end
                try
                    Xt = cbdataset(Xt,'labels',[{Lat},ModelOut.data.dataset.labobj(2:end)]);
                catch
                    errordlg(lasterr)
                end
            end
            
            
        else
            Xt   = load([Xfil{:}],Cont{Sel});
            Xt   = getfield(Xt,Cont{Sel});
            ModelIn.data.sizes=[]
            for i= 1:size(ModelIn.data.dataparafac2,2)
                ModelIn.data.sizes=[ModelIn.data.sizes;size(ModelIn.data.dataparafac2{i},2)]
            end
            [truc,bidule]=find((ModelIn.data.sizes-ones(size(ModelIn.data.sizes,1),1)*size(Xt,1))==0);
            if isempty(truc)
                errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
            end
            if ~isa(Xt,'cbdataset')
                Xt = cbdataset(Xt);
            end
            
        end
        
    else
        return
    end
end

ModelOut.prediction.data = Xt;
clear Xt
Constraints = ModelOut.options.constraints;
PredFun = 'parafac2pred';
Options=ModelOut.options;

PARAFAC2DisplayInfo(gcbf,ModelOut)
[ModelIn,ModelOut]=parafac2activateplots(ModelIn,ModelOut,X);

truc=size(ModelOut.prediction.data.data);
if size(truc) <3
    [ModelOut.prediction.xfactors{1},ModelOut.prediction.info.H, ModelOut.prediction.xfactors{3},ModelOut.prediction.xfactors{2}] = parafac2app({ModelOut.prediction.data.data'},ModelOut.model.nbfactors,Constraints,[],ModelOut.model.xfactors{1},ModelOut.model.core);
else
    [ModelOut.prediction.xfactors{1},ModelOut.prediction.info.H, ModelOut.prediction.xfactors{3},ModelOut.prediction.xfactors{2}] = parafac2app(ModelOut.prediction.data.data,ModelOut.model.nbfactors,Constraints,[],ModelOut.model.xfactors{1},ModelOut.model.core);
    
end

warning on

return
