function [Rank,Pos] = SelectModel(Ranks)
% function [Rank,Pos] = SelectModel (Ranks);
% 
% Description:
% Open a requester asking for the desired model complexity (when more than one has been computed)
% 
% Inputs: 
% Ranks: all the possible ranks (i.e. a vector with the contents of ModelOut.model(1:end).nbfactors
% 
% Outputs:
% Rank: selected rank
% Pos: position within ModelOut.model of the desired dimensionality
% 
% Called by:
% Model_PARAFAC\Plot_D_Statistic, Model_PARAFAC\Plot_IMP, Model_PARAFAC\Plot_Landscape, Model_PARAFAC\
% Plot_Loadings, Model_PARAFAC\Plot_Partial_RSS, Model_PARAFAC\Plot_Partial_RSS_OnLine, Model_PARAFAC\
% Plot_Quality, Model_PARAFAC\Plot_RIP
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:33:42
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

Rank     = 0;
Pos      = 0;
ListProp = {'selectionmode','single','name','Select model','promptstring','Select model''s rank'};
[Pos,Ok] = listdlg('Liststring',cellstr(sprintf('%i',Ranks)'),ListProp{:});
if ~Ok,return,end
Rank = Ranks(Pos);

