function [varargout] = scale_factors(flag,varargin)
% function [As,Bs,Cs,...] = Scale_factors (flag,A,B,C,...);
% 
% Description:
% Insert description here 'Color code: marroon' 
% 
% Inputs: 
% flag     : if 0 the norms of the loading vectors in the different loading matrices will be identical for
%            each factor; if 1 the first M-1 loading matrices passed are normalised to column length 1.
% A,B,C,...: loading matrices to be scaled
% 
% Outputs:
% As,Bs,Cs,...: scaled loading matrices.
% 
% Called by:
% Model_PARAFAC\FacOptScale, Model_PARAFAC\GNParafac, Model_PARAFAC\GenParafac
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 07-May-2002 16:08:06
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if nargin <= 3 & length(flag) ~= 1
   varargin = [{flag},varargin];
   flag     = 1;
end
if nargout ~= length(varargin)
    error('The number of outputs should match the number of inputs.')
end
for i=1:nargout-flag
   sc(i,:) = sqrt(sum(varargin{i}.^2)) .* sign(sum(varargin{i}.^3));
   varargout{i} = varargin{i} * diag(sc(i,:))^-1;
end
if flag
   varargout{nargout} = varargin{end} * diag(prod(sc,1));
else
   sig = sign(prod(sc,1));
   sc  = diag(sig)*diag(prod(abs(sc),1).^(1/length(varargin)));
   for i = 1:nargout
      varargout{i} = varargout{i} * sc;
   end
end
