function [Axes,MO] = Plot_Risk(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_Risk (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the risk (see html help) for a the models specified in ModelOut. The Risk values are stored in
% ModelOut.validation.stats.risk. If they are not present they are computed by means of Compute_Risk.
% For the axes specified by Axes the 'ModelOut' application-defined data is set, and it contains a copy
% of ModelOut (employed by PARAFACDisplayInfo).
%  
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the current model
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes with the Risk vs F plot.
% MO: ModelOut structure with the updated statistic. Empty if no new statistic was computed.
% 
% 
% 
% Called by:
% Model_PARAFAC\PARAFACActivatePlots
% NB. The actual call is made from PARAFACPlot via feval and not from Model_PARAFAC\PARAFACActivatePlots.
% 
% 
% 
% Subroutines:
% Internal: None
% External: compute_risk
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 03-Nov-2002 19:45:28
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
MO      = [];
Compute = isempty(ModelOut.validation(1).stats.risk);
if Compute
   Ans = questdlg({'These values need to be calculated, it may take some time.'},'Proceed','Proceed','Cancel','Proceed');
   if ~strcmp(Ans,'Proceed')
      return
   end
   Hand(1) = max([ModelOut.model.nbfactors]) * size(ModelOut.validation(1).segments,2);
   Hand(2) = 0;
   for i = 1:length(ModelOut.validation)
      [ModelOut.validation(i),Hand] = Compute_Risk(Hand,ModelOut.model(i),ModelOut.validation(i));
   end
   delete(Hand(1))
end
Axes = axes('tag','cbaxes','nextplot','replacechildren');
x    = [ModelOut.model(1).nbfactors - 1 ModelOut.model.nbfactors ModelOut.model(end).nbfactors + 1];
for i = 1:length(ModelOut.model)
   y(i,1) = ModelOut.validation(i).stats.risk;
end
y = [NaN;y;NaN];
Handles = bar(x,y);
title('\bfRisk(\itF)','fontname','arial','fontsize',10)
ylabel('Risk (A.U.)','fontname','arial','fontsize',9)
xlabel('Model Complexity (\itF)','fontname','arial','fontsize',9);
if min(y)<0;Ay(1) = 1.03*min(y(:));else;Ay(1) = 0.97*min(y(:));end
if max(y)<0;Ay(2) = 0.97*max(y(:));else;Ay(2) = min(max(x) * 2,1.03*max(y(:)));end
if Ay(1)==Ay(2);Ay(1)=Ay(1)-0.5;Ay(2)=Ay(2)+0.5;end
Ax = get(Axes,'xlim');
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127],'ylim',Ay,'xlim',Ax)
setappdata(Axes,'ModelOut',ModelOut)
grid on
if Compute
   MO   = ModelOut;
end
return
