function [Axes,MO] = Plot_RMSE(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_RMSE (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the PRESS (Prediction REsiduals Sum of Squares)vs F of the current model(s) as a bar plot. If
% present, validation and prediction PRESS are also plot along with the model. For the axes specified
% by Axes the 'ModelOut' application-defined data is set, and it contains a copy of ModelOut.(employed
% by PARAFACDisplayInfo)
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the current model
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes where the RMSE is plot
% MO: empty
% 
% 
% Called by:
% Model_PARAFAC\PARAFACActivatePlots
% NB. The actual call is made from PARAFACPlot via feval and not from Model_PARAFAC\
% PARAFACActivatePlots.
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:37:26
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO   = [];
Leg  = {'Calibration'};
Axes = axes('ydir','reverse',...
   'tag','cbaxes',...
   'nextplot','replacechildren');
x = [ModelOut.model(1).nbfactors - 1 ModelOut.model.nbfactors ModelOut.model(end).nbfactors + 1];
y = [ModelOut.model.xrmse]';
if ~isempty(ModelOut(1).validation) & ~isempty(ModelOut(1).validation(1).xrmse)
   y = [y,[ModelOut.validation.xrmse]'];
   Leg(end + 1) = {'Validation'};
end
if ~isempty(ModelOut(1).prediction)
   y            = [y,ModelOut.prediction.xrmse];
   Leg(end + 1) = {'Prediction'};
end
y = [NaN * ones(1,size(y,2));y; NaN * ones(1,size(y,2))];
if size(y,2) ~= length(Leg)
   Leg(size(y,2)+1:end) = [];
end
Handles = barh(x,y);
title(['\bfRMSE_' PlotStruct.additional.type2 ' vs \itF'],'fontname','arial','fontsize',10)
xlabel('RMSE','fontname','arial','fontsize',9)
ylabel('Model Complexity (\itF)','fontname','arial','fontsize',9);
legend(Handles,Leg{:},4)
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
setappdata(Axes,'ModelOut',ModelOut)
grid on
return
