function [Axes,MO] = Plot_IMP(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_IMP (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the IMP (Identity Match Plot) for a the component selected in the control figure opened with
% PARAFACPlotControls. For the axes specified by Axes the 'ModelOut' application-defined data is set,
% and it contains a copy of ModelOut.(employed by PARAFACDisplayInfo)
%  
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the current model
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes with the IMP.
% MO: empty
% 
% 
% Called by:
% Model_PARAFAC\PARAFACActivatePlots
% NB. The actual call is made from PARAFACPlot via feval and not from Model_PARAFAC\
% PARAFACActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: parafac, parafacplotcontrols, plottargetline, plotvalidation, selectmodel
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:41:06
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO = [];
if isempty(findobj(0,'type','figure','userdata','PARAFAC Plot Control'))
   %Called by the main window.
   PlotStruct.plotdims                = 0;
   PlotStruct.nummode                 = 1;
   Rank                               = 1;
   Ranks                              = [ModelOut.model.nbfactors]';
   Ranks(Ranks < PlotStruct.plotdims) = [];
   if length(Ranks) > 1
      Rank = SelectModel(Ranks);
      if ~Rank,return,end
   else
      Rank = Ranks;
   end
   Pos  = find([ModelOut.model.nbfactors] == Rank);
   ModelOut.model = ModelOut.model(Pos);
   if ~isempty(ModelOut.validation)
      ModelOut.validation = ModelOut.validation(Pos);
   end
   H = PARAFACPlotControls(PlotStruct,ModelOut,MainFig,1);
   waitfor(H,'waitstatus','Ok')
   if ~ishandle(H)
      Axes = [];
      return
   else 
      PlotStruct = getappdata(H,'PlotStr');
   end
end
PlotStruct.plotdims = 2;
figure(MainFig)
Axes = axes('tag','cbaxes','nextplot','replacechildren');
x    = ModelOut.model.xfactors{1}(:,PlotStruct.factors(1));
y    = ModelOut.validation.xfactors{1}(:,PlotStruct.factors(1),end);
PlotValidation(x,y,[],PlotStruct,ModelOut.data.dataset.labobj{1},Axes)
PlotTargetLine([1 0]')
xlabel('\bft\rm_{model}');
ylabel('\bft\rm_{-\itm}');
title(sprintf(['\\bfIdentity Match Plot: %i. Component'],PlotStruct.factors(1)),'fontname','arial','fontsize',10);
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
grid(PlotStruct.grid)
setappdata(Axes,'ModelOut',ModelOut)
return
