function [JTJ,Gr] = ParJac(Fac,X,Cols)
% function [JTJ,Gr] = ParJac (Fac,X,Cols);
% 
% Description:
% Calculates the JTJ matrix and the gradient of the loss function given the loading matrices for a
% PARAFAC model and the original array. It is faster than PARJacS.m but it is more memory-demanding.
% 
% Inputs: 
% Fac: cell array containing in each element a loading matrix, e.g. {A,B,C}
% X   : three way array on which the model has to be fitted
% Cols: logical vector defining the non constant parameters in the vector defined as [A(:);B(:);C(:)].
% 
% Outputs:
% JTJ: J'J, where J is the Jacobian matrix of the loss function with respect to the model's parameters
% Gr : gradient of the loss function with respect to the parameters
% 
% Called by:
% Model_PARAFAC\GNParafac
% 
% Subroutines:
% Internal: None
% External: kr
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 07-May-2002 16:56:12
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
% References
%

[A,B,C] = deal(Fac{:});
Dim  = size(X);
F    = size(A,2);
b    = [0 cumsum(Dim * F)];
if nargin < 3
   Cols = logical(ones(b(end),1));
end
Rows = ~isnan(X(:));
for i = 1:ndims(X)
   Dim2(i) = sum(Cols(b(i) + 1:b(i+1)));
end
a  = cumsum(Dim2);
Gr = zeros(sum(Cols),1);
BC = kr(C,B);
D  = zeros(prod(Dim),sum(Dim)*F);
for i = 1:Dim(1)
   D(i:Dim(1):Dim(1)*Dim(2)*Dim(3),i:Dim(1):Dim(1)*F) = BC;
end
D  = sparse(D(Rows,Cols(1:b(2))));
D2 = zeros(prod(Dim),Dim(2)*F);
AB = kr(B,A);
for j = 1:Dim(2)
   for k = 1:Dim(3)
      D2((k-1)*Dim(1)*Dim(2) + (j-1)*Dim(1)+1:(k-1)*Dim(1)*Dim(2) +j*Dim(1),j:Dim(2):Dim(2)*F)=A*diag(C(k,:));
   end
end
D  = [D,sparse(D2(Rows,Cols(b(2)+1:b(3))))];
D2 = zeros(prod(Dim),Dim(3)*F);
for k=1:Dim(3)
   D2((k-1)*Dim(1)*Dim(2)+1:k*Dim(1)*Dim(2),k:Dim(3):Dim(3)*F)=AB;
end
D   = [D,sparse(D2(Rows,Cols(b(3)+1:b(4))))];
M   = A*kr(C,B)';
Gr  = D'*(X(Rows) - M(Rows));
JTJ = D'*D;
%Time = Time + etime(clock,Time1);

