function Fit = PFLoss(X,Present,Delta,varargin)
% function Fit = PFLoss (X,Present,Delta,A,B,C,dA,dB,dC);
% 
% Description:
% Compute the value of the loss function for a three way PARAFAC after taking a step of length Delta
% along dA,dB and dC
% 
% Inputs: 
% X: I x J x K array
% Present: values in X to consider in estimating the loss function
% Delta: step length
% A,B,C: current loading matrices
% dA,dB,dC: updates for the loading matrices
% 
% Outputs:
% Fit: fit value with the updated loading matrices
% 
% Called by:
% Model_PARAFAC\GNLineSearch, Model_PARAFAC\GNParafac
% 
% Subroutines:
% Internal:None
% External: nmodel
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 09-May-2002 22:08:12
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if length(varargin) ~= ndims(X) * 2 & length(varargin) ~= ndims(X)
   error('Invalid number of arguments')
end

[Factors{1:ndims(X)}] = deal(varargin{1:ndims(X)});
if length(varargin) == ndims(X) * 2
   [Updates{1:ndims(X)}] = deal(varargin{ndims(X) + 1:end});
   for i = 1:ndims(X)
      Factors{i} = Factors{i} + Delta * Updates{i};
   end
end
M   = nmodel(Factors);
Fit = sum((X(Present)-M(Present)).^2);
