function ModelIn = InitModelIn(ModelIn)
% function ModelIn = InitModelIn (ModelIn);
% 
% Description:
% Checks that the ModelIn structure is compatible with PARAFACModel.
% 
% Inputs: 
% ModelIn: ModelIn structure prior to possible corrections.
% 
% 
% Outputs:
% ModelIn: corrected (if necessary) ModelIn structure
% 
% 
% Called by:
% PARAFACModel
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 29-Oct-2002 09:27:14
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

Constraints         = {'non-negativity','orthogonality','unimodality'}';
[a,Pos_Exist_Const] = intersect({ModelIn.constraints.name},Constraints);
if any(sum(cat(1,ModelIn.constraints.modes)) > 1);
   [ModelIn.constraints(Pos_Exist_Const).modes] = deal(zeros(size(ModelIn.constraints(Pos_Exist_Const(1)).modes)));
end
if length(ModelIn.nbfactors.min) > 1
   ModelIn.nbfactors.min = min(ModelIn.nbfactors.min(:));
end
if length(ModelIn.nbfactors.max) > 1
   ModelIn.nbfactors.max = max(ModelIn.nbfactors.max(:));
end
if ~isempty(ModelIn.nbfactors.min) & isempty(ModelIn.nbfactors.max)
   ModelIn.nbfactors.max = ModelIn.nbfactors.min + 1;
end
if isempty(ModelIn.nbfactors.min)
   ModelIn.nbfactors.min = 1;
end
if ~any(strcmp({'ALS','dGN'},ModelIn.options.algorithm.name))
   ModelIn.options.algorithm.name = 'ALS';
end
DefOptions = [1e-6 1e-6 1e-9 2 0 1 0 0 2];
if isempty(ModelIn.options.algorithm.constants) | ~isa(ModelIn.options.algorithm.constants,'double')
   ModelIn.options.algorithm.constants = DefOptions;
end
if length(ModelIn.options.algorithm.constants < 9)
   ModelIn.options.algorithm.constants(end+1:9) = DefOptions(length(ModelIn.options.algorithm.constants)+1:end);
end
if any(ModelIn.options.algorithm.constants(1:3) >= 1)
   e = find(ModelIn.options.algorithm.constants(1:3) >= 1);
   ModelIn.options.algorithm.constants(e) = DefOptions(e);
end
if ~any(1:6 == ModelIn.options.algorithm.constants(4)) 
   ModelIn.options.algorithm.constants(4) = 2;
end
if any(ModelIn.options.algorithm.constants([5 7 8]) ~= 0 & ModelIn.options.algorithm.constants([5 7 8]) ~= 1)
   e = 4 + find(ModelIn.options.algorithm.constants([5 7 8]) ~= 0 & ModelIn.options.algorithm.constants([5 7 8]) ~= 1);
   ModelIn.options.algorithm.constants(e) = DefOptions(e);
end
if ~any(1:3 == ModelIn.options.algorithm.constants(6))
   ModelIn.options.algorithm.constants(6) = DefOptions(6);
end
if rem(ModelIn.options.algorithm.constants(9),1) | ~floor(ModelIn.options.algorithm.constants(9))
   ModelIn.options.algorithm.constants(9) = floor(ModelIn.options.algorithm.constants(9)) + 1;
end
DefMaxIter = [2000 2000 5];
if ~isa(ModelIn.options.algorithm.maxiter,'double')
   ModelIn.options.algorithm.maxiter = DefMaxIter;
end
if any(rem(ModelIn.options.algorithm.maxiter,1))
   ModelIn.options.algorithm.maxiter = fix(ModelIn.options.algorithm.maxiter);
end
if any(~ModelIn.options.algorithm.maxiter)
   e = find(ModelIn.options.algorithm.maxiter);
   ModelIn.options.algorithm.maxiter(e) = DefMaxIter(e); 
end
if length(ModelIn.options.algorithm.maxiter(:)) < 3
   ModelIn.options.algorithm.maxiter(end+1:3) = DefMaxIter(length(ModelIn.options.algorithm.maxiter)+1:end); 
end
Avail_Val = {'loo','nboo','rboo','test'};
if ~isempty(ModelIn.valmethod.name)
   switch ModelIn.valmethod.name
   case {'loo','test'}
      [ModelIn.valmethod.segments,ModelIn.valmethod.replicates] = deal([]);
   case {'nboo','rboo'}
      ModelIn.segments   = [];
      if ~isa(ModelIn.valmethod.replicates,'double')
         ModelIn.valmethod.replicates = [];
      end
   end
else
   ModelIn.valmethod = struct('bootstrap',[],'name',[],'replicates',[],'segments',[]);
end
