function [DeltaMin,Fit] = gnlinesr(X,Present,Delta,varargin);
% function [DeltaMin,Fit] = GNLineSearch (X,Present,Delta,varargin);
% 
% Description:
% Line search procedure for Gauss Newton methods to fit a 3way PARAFAC model.
% It seeks the step length along a direction defined by dA, dB and dC providing a minimum of the loss function using a quadratic model.
% 
% Inputs: 
% X: I x J x K array
% Present: values in X to consider in estimating the loss function
% Delta: initial step length
% A,B,C: current loading matrices
% dA,dB,dC: updates for the loading matrices
%  
% 
% Outputs:
% DeltaMin: optimal step length along dA, dB and dC
% Fit: value of the loss functio at the optimal step
% 
% Called by:
% Model_PARAFAC\GNParafac
% 
% Subroutines:
% Internal: none
% External: pfloss
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 09-May-2002 21:22:08
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
%

dbg=0;
      
Delta                                    = max(.001,Delta);
[Factors{1:ndims(X)},UpDate{1:ndims(X)}] = deal(varargin{:});
Delta0                                   = Delta;
Fit1                                     = PFLoss(X,Present,0,Factors{:});
regx                                     = [1 0 0 Fit1];
Fit2                                     = PFLoss(X,Present,Delta,varargin{:});
regx                                     = [regx;1 Delta Delta.^2 Fit2];
Fit3                                     = PFLoss(X,Present,2*Delta,varargin{:});
regx                                     = [regx;1 2*Delta (2*Delta).^2 Fit3];
Count                                    = 0;

if Fit2 > Fit1
   while Fit2 > Fit1 & Count < 20
      Delta = Delta*.6;
      Fit2  = PFLoss(X,Present,Delta,varargin{:});
      regx  = [regx;1 Delta Delta.^2 Fit2];
      Count = Count + 1;
   end
   if Count == 20 | Delta < 1e-7
      Delta = 0;
   end
else
   Delta = 2 * Delta0;
   while Fit3 < Fit2
      Delta = 1.8*Delta;
      Fit3 = PFLoss(X,Present,Delta,varargin{:});
      regx=[regx;1 Delta (Delta).^2 Fit3];
   end
end
% Add one point between the two smallest fits
regx     = sortrows(regx,4);
if Delta 
   Delta4   = (regx(1,2) + regx(2,2))/2;
   Fit4     = PFLoss(X,Present,Delta4,varargin{:});
   regx     = [regx;1 Delta4 Delta4.^2 Fit4];
   reg      = regx(:,1:3)\regx(:,4);
   DeltaMin = -reg(2)/(2*reg(3));   %a*x2 + bx + c = fit
                                    %2ax + b = 0
                                    %x=-b/2a
   Fit      = PFLoss(X,Present,DeltaMin,varargin{:});
   regx     = sortrows(regx,4);
   if Fit > regx(1,4)
      DeltaMin = regx(1,2);
      Fit      = regx(1,4);
   end
   if ~DeltaMin
      disp(['Delta equal to 0']);
   end
   
else
   DeltaMin = regx(1,2);
   Fit      = regx(1,4);
end
% for i = 1:length(Factors)
%    varargout{i} = Factors{i} + DeltaMin * UpDate{i};
% end

