function CVHan = DefControls(h,ModelIn)
% function CVHan = DefControls (h,ModelIn);
% 
% Description:
% Creates the uicontrols and menus in the PARAFACModel figure. 'PARAFACModel(NaN)' is set as the
% standard callback function (whenever required)
% 
% Inputs: 
% h: handle to the PARAFACModel figure
% ModelIn: ModelIn structure
% 
% 
% Outputs:
% CVHan: structure holding the handles to the figure's uicontrols and menus
% 
% 
% Called by:
% PARAFACModel
% 
% Subroutines:
% Internal: None
% External: guinames
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Nov-2002 18:26:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GuiNames
bgc   = [0.13 0.3 0.6];
gr2   = [0.7514 0.7907 0.8201];
cbf   = 'PARAFACModel(NaN);';

FacTT  = ['Minimum and maximum number of factors',char(10),'separated by a coma: e.g. 3,5'];
Opt    = uimenu(la,'&Preferences');
Help   = uimenu(la,'&Help');

Alg            = uimenu(Opt,la,'&Algorithm');
CVHan.algc(1)  = uimenu(Alg,la,'&ALS',ud,'ALS',tg,'AlgChoice',cb,cbf);
CVHan.algc(2)  = uimenu(Alg,la,'&dGN',ud,'dGN',tg,'AlgChoice',cb,cbf);
CVHan.compress = uimenu(Alg,la,'&Compression',tg,'Compress',cb,cbf,sep{:});
uimenu(Alg,la,'&Options',cb,cbf,tg,'AlgOpt',sep{:});
CVHan.boomen  = uimenu(Opt,la,'&Bootstrap');
CVHan.booc(1) = uimenu(CVHan.boomen,la,'&Naive',ud,'nboo',tg,'BooChoice',cb,cbf);
CVHan.booc(2) = uimenu(CVHan.boomen,la,'&Residuals',ud,'rboo',tg,'BooChoice',cb,cbf);
uimenu(Help,la,'&About CuBatch',   cb,'AboutCuBatch')
uimenu(Help,la,'&Help',            cb,cbf,tg,'Help')
if length(ModelIn.var(1).dims) > 2
   set(CVHan.algc(2),dis{:})
end
if ~isempty(ModelIn.nbfactors.max)
   FactStr = sprintf(' %i , %i',ModelIn.nbfactors.min,ModelIn.nbfactors.max);
else
   FactStr = sprintf(' %i',ModelIn.nbfactors.min);
end
ValMet = strcmp({'loo','nboo','test','oth'},ModelIn.valmethod.name) | strcmp({'loo','rboo','test','oth'},ModelIn.valmethod.name);
Segm   = sprintf('%i',ModelIn.valmethod.segments);
Repl   = sprintf('%i',ModelIn.valmethod.replicates);

uicontrol(ty,tx,pos,[ 10 196 100  25],st,'N. of Factors',                                                bg,WIC,ari{:});
uicontrol(ty,ps,pos,[245  46 130  30],st,'Close',                                  cb,cbf,tg,'End',             ari{:});
uicontrol(ty,fr,pos,[ 10  10 225 180],                                                                   bg,FRC);
uicontrol(ty,tx,pos,[ 20 153  80  25],st,'Validate',                                                     bg,FRC,ari{:},ha,'left',fs,13);
CVHan.method   = uicontrol(ty,tx,pos,[ 21 115  80  25],st,'Method',                                                       bg,FRC,ari{:},ha,'left');
CVHan.val      = uicontrol(ty,ch,pos,[105 155 129  25],                            cb,cbf,tg,'validate', bg,FRC,ari{:});
CVHan.meth(1)  = uicontrol(ty,rb,pos,[105 115 129  36],st,'Leave One Out',         cb,cbf,tg,'loo',      bg,FRC,ari{:},va,ValMet(1),tt,'Cross Validation: repeated random segments');
CVHan.meth(2)  = uicontrol(ty,rb,pos,[105  91 129  36],st,'Bootstrap',             cb,cbf,tg,'nboo',     bg,FRC,ari{:},va,ValMet(2),on{:});
CVHan.meth(3)  = uicontrol(ty,rb,pos,[105  67 129  36],st,'Test set',              cb,cbf,tg,'test',     bg,FRC,ari{:},va,ValMet(3),tt,'Test Set Validation');
CVHan.segments = uicontrol(ty,tx,pos,[ 11  32  80  25],st,'Segments',                                    bg,FRC,ari{:});
CVHan.segmed   = uicontrol(ty,ed,pos,[105  33 100  30],st,Segm,                    cb,cbf,tg,'segments', bg,wh, ari{:});
CVHan.replicat = uicontrol(ty,tx,pos,[ 11  32  80  25],st,'Replicates',                                  bg,FRC,ari{:});
CVHan.repled   = uicontrol(ty,ed,pos,[105  33 100  30],st,Repl,                    cb,cbf,tg,'replica',  bg,wh, ari{:});
CVHan.stbutton = uicontrol(ty,ps,pos,[245  10 130  30],st,'Start ',                cb,cbf,tg,'StartBut',        ari{:});
CVHan.facted   = uicontrol(ty,ed,pos,[125 198 110  30],st,FactStr,                 cb,cbf,tg,'Factors',  bg,wh, ari{:},tt,FacTT);
CVHan.prepro   = uicontrol(ty,ps,pos,[245 198 130  30],st,'Preprocessing',         cb,cbf,tg,'PreTreat',        ari{:});
CVHan.const    = uicontrol(ty,ps,pos,[245 162 130  30],st,'Set Constraints',       cb,cbf,tg,'Const',           ari{:});