function Stats = DLims(Pred_Fun,Mode,Limit,Data,Model,Validation,ConfLim,FillIn,Segments,Stats,Cen,Scal,PreProc)
% function StatsOut = DLims(Pred_Fun,Mode,Limit,Data,Model,Validation,ConfLim,FillIn,Segments,StatsIn,Cen,Scal,PreProc);
% 
% Description:
% Computes the D-statistics, values, its limits, the contribution to the D-statistic of the different
% variables in the various dimensions of the array for a given nPLS1/PLS1 model. Apart from the
% contributions the statistics can be computed both in an 'offline' and an 'online' mode.
% NB This function will likely undergo some simplifications in the future releases of the syntax as
%    many of the input parameters are contained in the same data structure. 
% 
% 
% Inputs: 
% Pred_Fun  : function computing the prediction for the desired model. It can be a string (for MatLab 5.3 or superior) or  a function handle (for MatLab 6.x or superior)
% Mode      : 'on'/'off'  =>  'online'/'offline'
% Limit     : 0/1 compute/do not compute D-statistics limits (based on Data for the D-statistics
%             contributions)
% Data      : array of doubles with the data used to compute the statistics
% Model     : model's parameters as required by Pred_Fun (i.e. as a structure ModelOut.model)
% Validation: model's parameters as determined throught the validation procedure (ModelOut.validation).
%             It is not currently used but it can be employed in future releases to compute confidence
%             limits for the contributions to the D-statistic.
% ConfLim   : "alpha"s for the confidence intervals (if empty or not given: 95% and 99%). 
% FillIn    : fill in method: 'Current deviation'/'zero', necessary only when Mode is 'on'
% Segments  : Validation segments (ModelOut.validation.segments). Necessary only for D-statistics
%             contributions. 
%             NB. this parameter is somewhat superfluous as already contained in Validation and
%             therefore will likely be eliminated in future versions
% StatsIn   : structure holding the statistics (if previously calculated)
% Cen,Scal  : preprocessing parameters as contained in Model.xpreproc. 
% PreProc   : Stores the preprocessing information for the model of reference. It
%             contains two fields: 'modx' (for X) and 'mody' (for Y). Each of them has two
%             fields: 'cen' and 'scal', which are row vectors of the same length as the original
%             X and Y and refer to centre and scaling. 1 means centre/scale according to mean
%             and standard deviation. The 'scal' values can also be 2 (scaling with Root Mean
%             Squares) or 3 (scaling with Frobenius norm)%             
% 
% Outputs:
% StatsOut: structure holding the various statistics relative to Data. With respect to StatsIn the
%           fields relative to the D-statistics (with respect to Mode) are filled in.
% 
% Called by:
% Model_PARAFAC\Plot_DStatistics
% 
% Subroutines:
% Internal: None
% External: onlineres, Pred_Fun
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Nov-2002 12:05:42
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

% Define limits and compute the corresponding statistics
switch lower(Mode)
case 'off' 
   if ~any(strcmp(fieldnames(Stats),'s')) | isempty(Stats.s) 
      Stats.s    = nanmean(squeeze(Model.xfactors{1}(:,:,end)));
      Stats.sinv = inv(cov(squeeze(Model.xfactors{1}(:,:,end))));
   end
   Stats.s      = squeeze(Stats.s(end,:));
   Stats.sinv   = squeeze(Stats.sinv(:,:,end));
   T            = squeeze(Model.xfactors{1}(:,:,end));
   %D statistic
   Stats.d_off = diag((T-ones(size(T,1),1)*Stats.s) * Stats.sinv * (T-ones(size(T,1),1)*Stats.s)');
   Stats.dcon  = {{}};
   Z   = ones(1,Model.nbfactors);
   ZtZ = ones(Model.nbfactors);
   for i = length(Model.xfactors):-1:2
      Z   = kr(Z,Model.xfactors{i});
      ZtZ = ZtZ .* (Model.xfactors{i}'*Model.xfactors{i});
   end
   ZtZ  = pinv(ZtZ);
   SX   = size(cleanx(Data));
   Data = nprocess(cleanx(Data),PreProc.modx.cen,PreProc.modx.scal,Cen,Scal,1,-1);
   Z    = reshape(Z,[SX(2:end),Model.nbfactors]);
   if Model.nbfactors == 1
      Ind       = repmat({':'},ndims(Data),1);
      Ind{1}    = 1;
      t(Ind{:}) = Z(Ind{2:end});
      Z         = t;
   else
      Z   = permute(Z,[ndims(Z),1:ndims(Z)-1]);
   end
   %D statistic contribution
   %Not available if Data are not centred & no missing values are present
   if PreProc.modx.cen(1) & ~any(isnan(Data(:)))
   
      for k = 2:ndims(Data)
         
         Ind = repmat({':'},ndims(Data),1);
         for i = 1:size(Data,k)
         
            Ind{k}             = i;
            Dat                = nshape(Data(Ind{:}),1);
            P                  = nshape(Z(Ind{:}),1)' * ZtZ;
            Tcon               = Dat * P;
            Stats.dcon{k}(:,i) = diag(T * Stats.sinv * Tcon');
            
         end
         
      end
      
   else
      [Stats.dcon{2:ndims(Data)}] = deal('not available for non-centred data');
   end
   if Limit
      I              = size(Model.xfactors{1},1);
      R              = size(Model.xfactors{1},2);
      Stats.dlim_off = finv(ConfLim(:),R,I - R) * R * (I^2 - 1) / I / (I - R);
   end    
   
case 'on'
   [Nil,Nil,Nil,Nil,Stats.scores] = OnLineRes(Pred_Fun,Data,Model,FillIn,ConfLim,0,Cen,Scal,PreProc);
   if ndims(Stats.s) < 3 & Limit
      for t = 1:size(Stats.scores,3) %Along the time dimension
         Stats.s(t,:)      = meannan(Stats.scores(:,:,t));
         Stats.sinv(:,:,t) = inv(cov(squeeze(Stats.scores(:,:,t))));
      end 
   end
   Stats.d_on = [];
   for t = 1:size(Data,ndims(Data))
      T               = squeeze(Stats.scores(:,:,t)) - ones(size(Stats.scores,1),1)*Stats.s(t,:);
      Stats.d_on(:,t) = diag(T * squeeze(Stats.sinv(:,:,t)) * T');
   end
   if Limit
      I             = size(Model.xfactors{1},1);
      R             = Model.nbfactors;
      Stats.dlim_on = finv(ConfLim(:),R,I - R) * R * (I^2 - 1) / I / (I - R);
   end
   
end