function [Validation,Hand] = Compute_Risk(Hand,Model,Validation);
% function Validation = Compute_Risk (Hand,Model,Validation);
% 
% Description:
% Computes the risk value and the MSE between the models obtained by resampling (leave one out and
% bootstrap) and the reference model, i.e. the one computed on the whole set of batches/samples.
% 
% Inputs: 
% Hand      : at the first call is a vector of length 2, the first element is the total number of
%             replicates in all the models, the second a counter for the replicate being processed.
%             These two elements are moved to position 2 and 3 and the first element is the handle to
%             the waitbar opened by this very function.
% Model     : ModelOut.model structure
% Validation: ModelOut.validation structure
% 
% 
% Outputs:
% Validation: ModelOut.validation structure with an updated 'stats' field updated with the risk and the
%             MSE
% 
% 
% Called by:
% Model_PARAFAC\Plot_RIP, Model_PARAFAC\Plot_Risk
% 
% Subroutines:
% Internal: None
% External: facoptscale, facperm, recfac
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 03-Nov-2002 20:04:50
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

XModes = length(Model.xfactors);
if ~exist('ConfLim','var') | isempty(ConfLim)
   ConfLim = [0.95,0.99]';
end
if length(Hand) == 2;
   MaxIter = Hand(1);
   Status  = Hand(2);
   Hand    = [waitbar(0,'Please wait'),MaxIter,Status];
end
Fig     = Hand(1);
MaxIter = Hand(2);
Status  = Hand(3);
Validation.stats.risk = 0;
for i = 1:Model.nbfactors;
   for j = 1:length(Model.xfactors)
      Validation.stats.std{j}(:,i) = nanstd(squeeze(Validation(1).xfactors{1}(:,i,1:size(Validation.segments,2)))')';
   end
end
for j = 1:size(Validation.segments,2)
   if isequal(Validation.method,'rboo')
      RefFactors{1}  = Model.xfactors{1};
      SubMFactors{1} = squeeze(Validation.xfactors{1}(:,:,j));
   else
      RefFactors{1}  = Model.xfactors{1}(Validation.segments(:,j),:);
      SubMFactors{1} = Validation.xfactors{1}(Validation.segments(:,j),:,j);
   end
   for m = 2:XModes
      SubMFactors{m} = squeeze(Validation.xfactors{m}(:,:,j));
      RefFactors{m}  = Model.xfactors{m};
   end
   [R,Perm]                                     = RecFac('MitBur',SubMFactors{:},RefFactors{:});
   [SubMFactors{1:XModes}]                      = FacPerm(Perm,SubMFactors{1:XModes});
   [SubMFactors{1:XModes},RefFactors{1:XModes}] = FacOptScale(SubMFactors{1:XModes},RefFactors{:});
   Validation.stats.mse(:,:,j)                  = RecFac('MSE',SubMFactors{:},RefFactors{:});
   Validation.stats.risk                        = Validation.stats.risk + (length(R) - sum(R))/(length(R)*size(Validation.segments,2));
   Status = Status + 1;
   waitbar(Status/MaxIter,Fig)
   Hand(3) = Status;
end
