function [X,varargout] = CleanX(X);
% function [CleanX,IndX1,IndX2,...IndXn,...,IndY1,IndY2,...IndYm] = CleanX(X);
% 
% Description:
% Extracts the indexes on X corresponding to slabs that are not constituted only by missing values.
% 
% Inputs: 
% X: n-way array (where n >= 2)
% 
% Outputs:
% CleanX: "cleaned" n-way array (that is without slabs of sole missing values)
% IndX1,IndX2,...IndXn: indexes in the n-dimensions of X.
%  
% 
% Called by:
% Model_PARAFAC\GNParafac
% 
% Subroutines:
% Internal: None
% External: nshape
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Oct-2002 02:38:54
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 


ND   = ndims(X);
Xnan = isnan(X);
for i=1:ND
   Xv           = nshape(Xnan,i);
   Canc         = find(all(Xv,2));
   varargout{i} = setdiff(1:size(Xv,1),Canc);
end
X = X(varargout{:});


         
         
   