function PS = CheckPlotStruct(PlotStruct,MainFig)
% function PlotStructOut = CheckPlotStruct (PlotStruct,MainFig);
% 
% Description:
% Checks that the PlotStruct contents are compatible with the requirements of PARAFAC plot functions (
% Model_PARAFAC\private\Plot_*) and consistent with the validation method used, with whether it is an
% applied or computed model, etc. The function is called whenever a plot is requested via the
% PARAFACPlot function.
% 
% Inputs: 
% PlotStruct: PlotStruct data structure
% MainFig: main CuBatch figure handle
% 
% 
% Outputs:
% PlotStructOut: correct PlotStruct data structure
% 
% 
% Called by:
% Model_PARAFAC\PARAFACPlot
% 
% Subroutines:
% Internal: None
% External: ctag, getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:33:24
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

PS      = PlotStruct;
Apply   = getcvdata(gcbo,'Apply');
Colours = {'k',[0 0 0];...
      'b',[0 0 1];...
      'c',[0 1 1];...
      'g',[0 .5 0];...
      'm',[1 0 1];...
      'y',[1 1 0];...
      'r',[1 0 0]};
if ischar(PlotStruct.color) 
   if any(strcmp(Colours(:,1),PlotStruct.color))
      PS.color = Colours{strcmp(Colours(:,1),PlotStruct.color),2};
   else
      PS.color = 'b';
   end
end
if length(PS.nummode) > 1
   PS.nummode = PS.nummode(1);
end
if ~PS.nummode
   PS.nummode = 1;
end
if ~any(strcmp({'on','off','label','marker','number'},PlotStruct.visible))
   PS.visible = 'on';
end
if ~isempty(PlotStruct.additional.validation)
   if ~any([0 1 2 3] == PlotStruct.additional.validation)
      PS.additional.validation = 0;
   end
else
   PS.additional.validation = 0;
end
if Apply
   PS.visible               = 'label';
   PS.additional.validation = 1;
end
PS.type = ctag;
