function err = FacScaErr(x,j,varargin)
% function err = PARAFACScaErr (x,f,A,B,C,...,a,b,c,...);
% 
% Description:
% Euclidean distance between two sets of loadings vectors (only for the f-th component) for a PARAFAC model. 
% 
% Inputs: 
% x        : vector with the scaling factors for the first M-1 modes (the last is given by the inverse
%            of the products of the elements).
% f        : factor (i.e. column) to be "compared"
% A,B,C,...: first set of loadings
% a,b,c,...: second set of loadings
% 
% Outputs:
% err: Euclidean distance
% 
% 
% Called by:
% Model_PARAFAC\FacOptScale
% 
% Subroutines:
% Internal: None
% External: None
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 30-Jan-2002 14:13:58
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

err = 0;
Dims = nargin / 2 - 1;
for i = 1:Dims - 1
   err = err + norm(varargin{i}(:,j) - x(i) * varargin{Dims + i}(:,j));
end
err = err + norm(varargin{Dims}(:,j) - prod(x)^-1 * varargin{2*Dims}(:,j));