function PARAFACReport(MainFig,ReportStruct,Fil_id)
% function PARAFACReport (MainFig,ReportStruct,Fil_id);
% 
% Description:
% Handles the report for the Model/Validation/Projection parts when the current model (i.e. the model
% saved in the 'Results' application-defined data of the main figure) is a PARAFAC model. The parts to
% report are defined in the ReportStruct structure, which is passed by the calling function.
% 
% Inputs: 
% MainFig     : handle to the main figure
% ReportStruct: ReportStruct structure, with flags relative to which information should be saved in the
%               .txt file
% Fil_id      : handle to the .txt file
% 
% 
% Outputs:
% None
%  
% 
% Called by:
% SaveReport
% 
% Subroutines:
% Internal: None
% External: getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 02-Nov-2002 18:09:56
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

ModelOut = getcvdata(MainFig,'Results');
if any(ReportStruct.m_info)

   %Model info and name
   fwrite(Fil_id,[10 'Model               : PARAFAC' 10],'char');
   fwrite(Fil_id,['Number of factors   : '],                    'char');
   fwrite(Fil_id,[sprintf(' %i',[ModelOut.model.nbfactors]),10 10],'char');
   %Preprocessing. NB the different scalings are not distinguished
   fwrite(Fil_id,[   'Preprocessing'                 10],'char');
   fwrite(Fil_id,[   'Centring            : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.modx.cen(:)') 10],'char');
   fwrite(Fil_id,[   'Scaling             : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.modx.scal(:)') 10],'char');

%Constraints
   fwrite(Fil_id,[10 'Constraints'                   10],'char');
   for i = 1:length(ModelOut.info.constraints)
      
      fwrite(Fil_id,sprintf('Mode [%i] - ',i),'char');
      if ModelOut.info.constraints(i) == 1
         fwrite(Fil_id,[ModelOut.data.dataset.modenames{i}, ': Orthogonality'  10],'char');
      elseif ModelOut.info.constraints(i) == 2
         fwrite(Fil_id,[ModelOut.data.dataset.modenames{i}, ': Non-negativity' 10],'char');
      elseif ModelOut.info.constraints(i) == 3
         fwrite(Fil_id,[ModelOut.data.dataset.modenames{i}, ': Unimodality'    10],'char');
      else
         fwrite(Fil_id,[ModelOut.data.dataset.modenames{i}, ': No constraints' 10],'char');
      end
      
   end
   %Algorithm information
   fwrite(Fil_id,[10,'Algorithm           : ' ModelOut.info.algorithm 10],'char');
   if strcmp('dGN',ModelOut.info.algorithm) & ModelOut.info.constants(5)
   
      fwrite(Fil_id,['                      FRIN applied' 10],'char');
      fwrite(Fil_id,['Line search         : '],'char');
      if ModelOut.info.constants(6) == 0
         fwrite(Fil_id,['No' 10],'char');
      elseif ModelOut.info.constants(6) == 1
         fwrite(Fil_id,['Iteration' 10],'char');
      elseif ModelOut.info.constants(6) == 2
         fwrite(Fil_id,['Divergence' 10],'char');
      end
      fwrite(Fil_id,['Large data routines : '],'char');
      if ModelOut.info.constants(8)
         fwrite(Fil_id,['Yes' 10],'char');
      else
         fwrite(Fil_id,['No' 10],'char');
      end
      
   end
   fwrite(Fil_id,'Compression         : ','char');
   if ModelOut.info.constants(7)
      fwrite(Fil_id,['Yes' 10],'char');
      fwrite(Fil_id,'Tucker extra-factors: ','char');
      fwrite(Fil_id,[int2str(ModelOut.info.constants(9)) 10 10],'char');
   else
      fwrite(Fil_id,['No' 10],'char');
   end
   %Initialisation
   Init    = {'Random','Orth','NIPALS','DTLD','SWATLD','Best'};
   fwrite(Fil_id,'Initialisation      : ',                           'char');
   fwrite(Fil_id,[Init{ModelOut.info.constants(4)},10],'char');
   if ModelOut.info.constants(4) ~= 4
      fwrite(Fil_id,[   'Init. max iterations: '],              'char');
      fwrite(Fil_id,[int2str(ModelOut.info.maxiter(3)),10],     'char');
   end
   %Convergence criteria
   fwrite(Fil_id,[10,'Convergence criteria: ' 10],                   'char');
   fwrite(Fil_id,[   'Relative fit        : '],                      'char');
   fwrite(Fil_id,[sprintf('%1.0e',ModelOut.info.constants(1)),10],   'char');
   if strcmp('dGN',ModelOut.info.algorithm)
      fwrite(Fil_id,['Parameters change   : '],                      'char');
      fwrite(Fil_id,[sprintf('%1.0e',ModelOut.info.constants(2)),10],'char');
      fwrite(Fil_id,['Gradient            : '],                      'char');
      fwrite(Fil_id,[sprintf('%1.0e',ModelOut.info.constants(3)),10],'char');
   end
   %Max iterations
   fwrite(Fil_id,[10,'Max # iterations' 10],                    'char');
   fwrite(Fil_id,[   'Fitting             : '],                 'char');
   fwrite(Fil_id,[int2str(ModelOut.info.maxiter(1)),10],        'char');
   if ModelOut.info.constants(7)
      fwrite(Fil_id,[   'Refining            : '],              'char');
      fwrite(Fil_id,[int2str(ModelOut.info.maxiter(2)),10],     'char');
   end
   
end
if any(ReportStruct.v_info)
   
   %Validation info
   fwrite(Fil_id,[10 10],'char');
   fwrite(Fil_id,['Validation',10],'char');
   fwrite(Fil_id,['Method              : '],'char');
   fwrite(Fil_id,[ModelOut.validation(1).method 10],'char');
   %Segments composition
   if strcmp(ModelOut.validation(1).method,'test')
      fwrite(Fil_id,['Test set (samples/batches position within ModelOut.data.dataset)',10],'char');
   else
      fwrite(Fil_id,['Segments (samples/batches position within ModelOut.data.dataset)',10],'char'); 
   end
   Mat = num2str(ModelOut.validation(1).segments);
   Mat = [Mat,10 * ones(size(Mat,1),1)]';
   fwrite(Fil_id,Mat,'char');
   
end
for i = 1:length(ModelOut.model)
   
   if any(ReportStruct.m_results);
      
      fwrite(Fil_id,[10 10],'char');
      fwrite(Fil_id,['Model Results',10],'char');
      fwrite(Fil_id,['Number of factors   : '],'char');
      fwrite(Fil_id,[int2str(ModelOut.model(i).nbfactors),10],    'char');
      fwrite(Fil_id,['Number of iterations: '],'char');
      fwrite(Fil_id,[int2str(ModelOut.model(i).iterations(1)), '(Fitting)' 10],'char');
      if ModelOut.info.constants(7)
         fwrite(Fil_id,['                      '],'char');
         fwrite(Fil_id,[int2str(ModelOut.model(i).iterations(2)), '(Refining)' 10],'char');       
      end
      fwrite(Fil_id,['Explained variation : '],'char');
      fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut.model(i).xev),10],  'char');
      fwrite(Fil_id,['X RMSE              : '],'char');
      fwrite(Fil_id,[sprintf('%3.2f',ModelOut.model(i).xrmse),10],'char');
      fwrite(Fil_id,['Factors',10],'char');
      for j = 1:length(ModelOut.model(i).xfactors)
         
         fwrite(Fil_id,sprintf('Mode [%i] - ',j),'char');
         fwrite(Fil_id,ModelOut.data.dataset.modenames{j},'char');
         fwrite(Fil_id,[': ' 10],'char');
         Mat = num2str(ModelOut.model(i).xfactors{j});
         Mat = [Mat,10 * ones(size(Mat,1),1)]';
         fwrite(Fil_id,Mat,'char');
         fwrite(Fil_id,[10 10],'char');
         
      end
      
   end
   if any(ReportStruct.v_results);
      
      if ~any(ReportStruct.m_results),fwrite(Fil_id,[10 10],'char');end
      fwrite(Fil_id,['Validation Results',10],'char');
      switch ModelOut.validation(1).method
         case {'test','loo'}
            fwrite(Fil_id,['Explained variation : '],'char');
            fwrite(Fil_id,sprintf(['%3.2f%%', 10],ModelOut.validation(i).xev),'char');
            fwrite(Fil_id,['X RMSE              : '],'char');
            fwrite(Fil_id,[sprintf('%3.2f',ModelOut.validation(i).xrmse),10],'char');
            fwrite(Fil_id,['Factors',10],'char');
            fwrite(Fil_id,sprintf('Mode [%i] - ',1),'char');
            fwrite(Fil_id,[ModelOut.data.dataset.modenames{1} 10],'char');
            T   = ModelOut.validation(i).xfactors;
            if strcmp(ModelOut.validation(1).method,'loo') 
               Mat = num2str(squeeze(T{1}(:,:,end)));
            else
               Mat = num2str(squeeze(T{1}(ModelOut.validation(1).segments,:,end)));
            end
            Mat = [Mat,10 * ones(size(Mat,1),1)]';
            fwrite(Fil_id,Mat,'char');
            
         case {'nboo','rboo'}
            fwrite(Fil_id,['No additional info available yet for bootstrap',10],'char');
            
      end
      
   end
   
end
if any(ReportStruct.p_results);
   fwrite(Fil_id,10,'char');
   fwrite(Fil_id,['Projection Results',10],                          'char');
   fwrite(Fil_id,['Number of factors   : '],                         'char');
   fwrite(Fil_id,[sprintf(' %i',[ModelOut.prediction.nbfactors]),10],'char');
   fwrite(Fil_id,'Fill in             :  ','char');
   if ModelOut.info.initialsize ~= size(ModelOut.prediction.data,ndims(ModelOut.prediction.data))
      fwrite(Fil_id,[ModelOut.info.fillin,10],                   'char');
      fwrite(Fil_id,['Initial Length      :  '],                 'char');
      fwrite(Fil_id,[sprintf('%i',ModelOut.info.initialsize),10],'char');
   else
      fwrite(Fil_id,['None',10],'char');
   end
   fwrite(Fil_id,['Explained variation : '],'char');
   fwrite(Fil_id,sprintf(['%3.2f%%', 10],ModelOut.prediction.xev),'char');
   fwrite(Fil_id,['X RMSE              : '],'char');
   fwrite(Fil_id,[sprintf('%3.2f',ModelOut.prediction.xrmse),10],'char');
   fwrite(Fil_id,['Factors',10],'char');
   fwrite(Fil_id,sprintf('Mode [%i] - ',1),'char');
   fwrite(Fil_id,ModelOut.data.dataset.modenames{1},'char');
   fwrite(Fil_id,[': ' 10],'char');
   Mat = num2str(ModelOut.prediction.xfactors{1});
   Mat = [Mat,10 * ones(size(Mat,1),1)]';
   fwrite(Fil_id,Mat,'char');
   fwrite(Fil_id,[10 10],'char');
end
return