function Predictions = PARAFACPred(X,Model_Parameters,varargin)
% function Predictions = PARAFACPred (X,Model_Parameters,varargin);
% 
% Description:
% Applies a PARAFAC model to the data contained in X. The model is defined by Model_Parameters.
% It is PARAFAC PredFun (see FitModel).
% 
% Inputs: 
% X               : double array of data
% Model_Parameters: ModelOut.model structure or cell vector of doubles (output of parafac)
% varargin        : additional inputs for the parafac function (i.e. Options, Constraints, etc); some
%                   of these are not available (e.g. the modes not referring to the samples are fixed).
% 
% 
% Outputs:
% Predictions: structure with two fields
% 
% xfactors, matrix of doubles with the new scores 
% xpred, predictions for X.
%   
% Called by:
% Model_PARAFAC\PARAFACApply, Model_PARAFAC\PARAFACGNPred, Model_PARAFAC\Calculate, Model_PARAFAC\Plot_D_Statistic, Model_PARAFAC\Plot_Partial_RSS_OnLine
% 
% Subroutines:
% Internal: None
% External: nmodel, parafac
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 08-Oct-2002 16:32:54
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if isa(Model_Parameters,'struct')
   F                = Model_Parameters.nbfactors;
   Model_Parameters = Model_Parameters.xfactors;
else
   F = size(Model_Parameters{1},2);
end
Ain                  = rand(size(X,1),F);
[varargin{[1,3:4]}]  = deal([eps,0 0 0 NaN 10000],[{Ain},Model_Parameters(2:end)],[0 ones(1,length(Model_Parameters)-1)]);
Factors              = parafac(X,F,varargin{:});
Predictions.xpred    = nmodel(Factors);
Predictions.xfactors = Factors{1};