function Handles_Win = PARAFACPlotControls(PlotStruct,ModelOut,MainFig,Add_in)
% function Handles_Win = PARAFACPlotControls (PlotStruct,ModelOut,MainFig,Add_in);
% 
% Description:
% It opens the window allowing to choose some options for the desired plots. The execution is paused
% the first time this window is called and resumed after the first plot. Until another plot is selected
% from the menus of the main window the last window created with this function is kept open. Any choice
% therefore made in such a window will refer to the model saved as 'ModelOut' in the current axes.
% ParafacPlot is called every time the 'Plot' button is pressed apart from the very first time. In the
% latter case the execution will simply be resumed within the calling function. It defines the
% application-defined data:
%    Results   : ModelOut structure 
%    PlotStruct: PlotStruct structure 
%    Handlers  : handles to some objects within the "Control" figure 
%    MainFig   : handle to the main window 
% Some of these are named and created to mimic the main figure's application defined data relevant for
% the plotting.
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut  : ModelOut structure
% MainFig   : handle to the main figure
% Add_in    : 1 (0 is default) if the selector for the desired number of components must not be visible
%            (not used here,).
% 
% 
% Outputs:
% Handles_Win: handle to the figure opened by this function
% 
% 
% Called by:
% Model_PARAFAC\Plot_IMP, Model_PARAFAC\Plot_Loadings
% 
% Subroutines:
% Internal: None
% External: parafacplot, guinames, setcvdata, skcell, cenwindow, ctag, cval, getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Nov-2002 09:23:56
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%


if ~exist('Add_in','var')
   Add_in = 0;
end
cbf = 'PARAFACPlotControls(NaN);';
PlotInfo = [];
GuiNames
if isa(PlotStruct,'struct')
   %Open window
   Handles_Win = CenWindow(WIC,'PARAFAC Plot',cbf,385,238);
   set(Handles_Win,'toolbar','none','userdata','PARAFAC Plot Control',tg,'plot control')
   
   %Define controls
   uicontrol(ty,fr,pos,[  7 163 371 67],bg,FRC)
   uicontrol(ty,fr,pos,[  7  85 371 72],bg,FRC)
   uicontrol(ty,fr,pos,[  7  43 371 36],bg,FRC)
   uicontrol(ty,ps,pos,[245   8 130 30],st,'Cancel',tg,'cancel',cb,cbf,ari{:});
   temmenhan = uicontrol(ty,ps,pos,[ 10   8 130 30],st,'Plot',tg,'Plot',cb,cbf,ari{:});
   setcvdata(temmenhan,'Apply',getcvdata(gcbo,'Apply'))
   uicontrol(ty,tx,pos,[ 10  44  85 25],st,'Display',bg,FRC,ari{:})
   uicontrol(ty,pu,pos,[ 95  43 130 30],st,{'Integer','Label','Marker','No Marker'},va,PlotStruct.format(1),cb,cbf,tg,'Labelling',bg,'w',ari{:});
   uicontrol(ty,pu,pos,[235  43 130 30],st,{'Continuous','Discrete'},va,PlotStruct.format(2),cb,cbf,tg,'Continuous',bg,'w',ari{:});
   Flag = 1; 
   Han(1) = uicontrol(ty,rb,pos,[ 15 100 130 30],st,'Replicates',off{:},cb,cbf,tg,'Validation',ud,2,bg,FRC,ari{:});
   Han(2) = uicontrol(ty,rb,pos,[156 100 130 30],st,'Predicted',off{:},cb,cbf,tg,'Validation',ud,1,bg,FRC,ari{:});
   Han(3) = uicontrol(ty,tx,pos,[15 126 130 25],st,'Show Validation:',off{:},bg,FRC,ari{:},fw,'demi');
   Factors = skcell(1,ModelOut.model.nbfactors,'Component')';
   if ~PlotStruct.factors(1) & PlotStruct.plotdims == 1
      AxF = length(Factors) + 1;
   else
      AxF = min(max(PlotStruct.factors(1),1),max([ModelOut.model.nbfactors]));
   end
   if PlotStruct.plotdims == 0
      Han(4)  = uicontrol(ty,pu,pos,[101 185 130 30],st,Factors,va,PlotStruct.factors(1),cb,cbf,tg,'X axis',bg,'w',ari{:});
   elseif PlotStruct.plotdims == 1
      Factors = [Factors(:);{'All'}];
      Han(4)  = uicontrol(ty,pu,pos,[101 185 130 30],st,Factors,va,AxF,cb,cbf,tg,'X axis',bg,'w',ari{:});
      if ~PlotStruct.factors(1)
         set(Han(1:2),dis{:})
      end
   elseif PlotStruct.plotdims == 2
      uicontrol(ty,pu,pos,[ 31 180 130 30],st,Factors,va,AxF,cb,cbf,tg,'X axis',bg,'w',ari{:});
      uicontrol(ty,tx,pos,[161 178  65 30],st,'versus',bg,FRC,ari{:});
      uicontrol(ty,pu,pos,[226 180 130 30],st,Factors,va,PlotStruct.factors(2),cb,cbf,tg,'Y axis',bg,'w',ari{:});
   else
      
      uicontrol(ty,pu,pos,[ 10 180 101 30],st,Factors,va,AxF,cb,cbf,tg,'X axis',bg,'w',ari{:});
      uicontrol(ty,tx,pos,[111 178  30 30],st,'vs',bg,FRC,ari{:});
      uicontrol(ty,pu,pos,[141 180 101 30],st,Factors,va,PlotStruct.factors(2),cb,cbf,tg,'Y axis',bg,'w',ari{:});
      uicontrol(ty,tx,pos,[243 178  30 30],st,'vs',bg,FRC,ari{:});
      uicontrol(ty,pu,pos,[274 180 101 30],st,Factors,va,PlotStruct.factors(3),cb,cbf,tg,'Z axis',bg,'w',ari{:});
      
   end
   if ~Add_in & isempty(ModelOut.prediction) & ~isempty(ModelOut.validation)
      switch ModelOut.validation.method
      case 'loo'
         set(Han([1,3]),on{:})
         if PlotStruct.nummode == 1
            set(Han(2),on{:})
         end
      case {'nboo','rboo'}
         set(Han([1,3]),on{:})
      case 'test'
         if PlotStruct.nummode == 1
            set(Han(2),pos,[15 100 130 30],on{:})
            set(Han(3),on{:})
         end
      end
   else
      if isempty(ModelOut.prediction)
         Flag = 0;
      end
   end
   
   %Define menus
   Pref = uimenu(Handles_Win,la,'Preferences');
   Help = uimenu(Handles_Win,la,'Help');
   uimenu(Help,la,'&About CuBatch',cb,'AboutCuBatch')
   uimenu(Help,la,'&Help',         cb,cbf,tg,'Help')
   
   %Choose colour menu
   Handles_Colours = uimenu(Pref,la,'Colour');
   %Custom must remain the last!
   Colours = {'Standard','colormap',[];...
         'Black','k',[0 0 0];...
         'Blue','b',[0 0 1];...
         'Green','g',[0 .5 0];...
         'Magenta','m',[1 0 1];
         'Red','r',[1 0 0];...
         'Custom','custom colour',PlotStruct.color};
   for i = 1:size(Colours,1)
      Handles_Custom = uimenu(Handles_Colours,la,Colours{i,1},tg,Colours{i,2},cb,cbf,ud,Colours{i,3});
   end
   set(Handles_Custom,sep{:})
   
   %Choose marker menu
   Handles_Marker = uimenu(Pref,la,'Marker',sep{:});
   %Poly has to remain the last!
   Markers = {'Asterisk','*';'Circle','o';'Cross','x';'Diamond','d';'Exagram','h';'Pentagram','p';'Plus','+';...
         'Point','.';'Square','s';'Triangle up','^';'Triangle down','v';'Triangle left','<';'Triangle right','>';'Polygons','poly'};
   for i = 1:size(Markers,1)
      Handles_Poly = uimenu(Handles_Marker,la,Markers{i,1},tg,Markers{i,2},cb,cbf);
   end
   set(Handles_Poly,sep{:})
   %Choose linestyle menu
   Handles_Line  = uimenu(Pref,la,'Line style');
   Lines = {'Solid','-';'Dashed','--';'Dotted',':';'Dash-Dot','-.'};
   for i = 1:size(Lines,1)
      uimenu(Handles_Line,la,Lines{i,1},tg,Lines{i,2},cb,cbf)
   end
   
   %Grid on/off
   uimenu(Pref,la,'Grid',cb,cbf,tg,'grid',cc,PlotStruct.grid,sep{:});
   
   if Flag
      Handles_Vis = uimenu(Pref,la,'&Show model',sep{:});
      uimenu(Handles_Vis,la,'&default',cb,cbf,tg,'Model',ud,'on')
      uimenu(Handles_Vis,la,'&marker', cb,cbf,tg,'Model',ud,'marker')
      uimenu(Handles_Vis,la,'&labels', cb,cbf,tg,'Model',ud,'label')
      uimenu(Handles_Vis,la,'n&umber', cb,cbf,tg,'Model',ud,'number')
      uimenu(Handles_Vis,la,'&no',     cb,cbf,tg,'Model',ud,'off')
   else 
      Handles_Vis = [];
   end
   
   %Set values
   set(findobj(Han(1:2),ud,PlotStruct.additional.validation),va,1)
   if PlotStruct.plotdims ~= 1% & PlotStruct.nummode == 1
      set(Handles_Poly,on{:});
   else
      if strcmp(PlotStruct.marker,'poly')
         PlotStruct.marker = '.';
      end
      set(Handles_Poly,off{:})
   end
   if strcmp(PlotStruct.marker,'poly')
      set(Handles_Poly,con{:})
   else
      set(Handles_Poly,cof{:})
   end
   if PlotStruct.format(1) ~= 3
      set(Handles_Marker,dis{:})
   else
      set(Handles_Marker,en{:})
   end
   set(min(findobj(Handles_Colours,ud,PlotStruct.color)),con{:})
   set(findobj(Handles_Marker,tg,PlotStruct.marker),con{:})
   set(findobj(Handles_Vis,ud,PlotStruct.visible),con{:})
   set(findobj(Handles_Line,tg,PlotStruct.linestyle),con{:})
   if ~strcmp(get(findobj(Handles_Vis,ud,PlotStruct.visible),la),'&no')
      set(Handles_Vis,con{:})
   end
   if PlotStruct.additional.validation
      set(Handles_Vis,en{:})
      if PlotStruct.additional.validation == 2
         set(Handles_Poly,en{:})
      else
         set(Handles_Poly,dis{:})
      end
   else
      set([Handles_Vis,Handles_Poly],dis{:})
   end
   if PlotStruct.format(2) ~= 1
      set(Handles_Line,dis{:})
   else
      set(Handles_Line,en{:})
   end
   setcvdata(Handles_Win,'PlotStr',PlotStruct,'Results',ModelOut,'Handlers',Han,'MainFig',MainFig);
   
else
   [PlotStruct,Han,Model,MainFig] = getcvdata(gcbf,'PlotStr','Handlers','Results','MainFig');
   switch ctag
   case {'X axis','Y axis','Z axis'}
      Axes = find(strcmp({'X axis','Y axis','Z axis'},ctag));
      if PlotStruct.plotdims == 1 & cval == length(get(gcbo,st))
         PlotStruct.factors(Axes) = 0;
         set(Han(1:2),dis{:})
         PlotStruct.additional.validation = 0;
      else
         PlotStruct.factors(Axes) = cval;
         set(Han(1:2),en{:})
      end
      
   case 'Model'
      set(allchild(get(gcbo,PNT)),cof{:})
      set(gcbo,con{:})
      PlotStruct.visible = get(gcbo,ud);
      if strcmp(PlotStruct.visible,'off')
         set(get(gcbo,PNT),cof{:})
      else
         set(get(gcbo,PNT),con{:})
      end
         
      
   case 'Validation'
      PlotStruct.additional.validation = (get(gcbo,ud))*cval;
      a                                = findobj(gcbf,tg,'Validation');
      set(a,va,0)
      set(gcbo,va,PlotStruct.additional.validation~=0);
      if PlotStruct.additional.validation == 2
         set(findobj(gcbf,tg,'poly'),en{:})
      else
         set(findobj(gcbf,tg,'poly'),dis{:})
         if strcmp(PlotStruct.marker,'poly')
            PlotStruct.marker = '.';
            set(get(get(findobj(gcbf,'type','uimenu','tag','.'),PNT),'children'),cof{:})
            set(findobj(gcbf,'type','uimenu','tag','.'),con{:})
         end
      end
      if PlotStruct.additional.validation
         set(findobj(gcbf,la,'&Show model'),en{:})
      else
         set(findobj(gcbf,la,'&Show model'),dis{:})
         set(get(findobj(gcbf,la,'&Show model'),'children'),cof{:})
         set(findobj(gcbf,la,'&default',tg,'Model',ud,'on'),con{:})
         PlotStruct.visible = 'on';
      end
      if PlotStruct.plotdims == 1
         set(Han(4),va,max(1,min(get(Han(4),va),length(get(Han(4),st))-1)))
      end
      
   case 'Labelling'
      PlotStruct.format(1) = cval;
      if cval ~= 3
         set(findobj(gcbf,la,'Marker'),dis{:})
         PlotStruct.marker = 'None';
         if cval == 4
            set(get(findobj(gcbf,la,'Marker'),'children'),cof{:})
            PlotStruct.format(2) = 1;
            set(findobj(gcbf,la,'Line style'),en{:})
            set(findobj(gcbf,'type','uicontrol',tg,'Continuous'),va,1)
         end
      else
         set(findobj(gcbf,la,'Marker'),en{:})
         if strcmp(PlotStruct.marker,'None')
            PlotStruct.marker = '.';
            set(findobj(gcbf,'type','uimenu',tg,'.',la,'Point'),con{:})
         end
      end
      
   case 'Continuous'
      PlotStruct.format(2) = cval;
      if cval ~= 1
         set(findobj(gcbf,la,'Line style'),dis{:})
         if PlotStruct.format(1) == 4 %no marker also
            PlotStruct.format(1) = 3;
            set(findobj(gcbf,'type','uicontrol',tg,'Labelling'),va,3)
            set(findobj(gcbf,la,'Marker'),en{:})
            if strcmp(PlotStruct.marker,'None')
               PlotStruct.marker = '.';
               set(findobj(gcbf,'type','uimenu',tg,'.',la,'Point'),con{:})
            end
         end
      else
         set(findobj(gcbf,la,'Line style'),en{:})
      end
      
   case {'colormap','r','g','b','k','m','custom colour'}
      set(allchild(get(gcbo,PNT)),cof{:})
      set(gcbo,con{:})
      if strcmp(ctag,'custom colour')
         if isempty(PlotStruct.color)
            PlotStruct.color = 'b';
         end
         c                = uisetcolor(PlotStruct.color);
         PlotStruct.color = c;
      else
         PlotStruct.color = get(gcbo,ud);
      end
      
      
   case {'*','o','x','d','h','+','p','.','s','^','v','>','<','poly'}
      set(allchild(get(gcbo,PNT)),cof{:})
      set(gcbo,con{:})
      PlotStruct.marker = ctag;
      
   case {'-','--','-.',':'}
      set(allchild(get(gcbo,PNT)),cof{:})
      set(gcbo,con{:})
      PlotStruct.linestyle = ctag;
      
   case 'grid'
      if strcmp(get(gcbo,cc),'on')
         set(gcbo,cof{:})
      else
         set(gcbo,con{:})
      end
      PlotStruct.grid = get(gcbo,cc);
      
   case {'plot control','cancel'}
      delete(gcbf)
      return
      
   case PlotStruct.type
      PARAFACPlot(gcbf,MainFig)
      return
      
   case 'Plot'
      H = gcbf;
      set(gcbo,'tag',PlotStruct.type)
      set(H,'waitstatus','Ok')
      return
      
   case 'Help'
      a   = lower(which('CuBatch'));
      a   = strrep(a,'cubatch.m','Help/user/res/resparafac.html#Score/Loadings');
      stat=web(['file:///' a],'-browser');

   end
   setcvdata(gcbf,'PlotStr',PlotStruct);
   
   %Callback mode
end
