function PARAFACPlot(FigHandle,MainFig);
% function PARAFACPlot (FigHandle,MainFig);
% 
% Description:
% Handles the plotting functions for the desired PARAFAC model. It checks the PlotStruct structure and
% the position of the plotting axes within the figure. The plotting functions are called via feval and
% the name of the function to call is stored in the menu's tag. If FigHandle is 'default
% plot' and MainFig is a ModelOut structure the default plot (i.e. explained variation) is shown. If th
% Results'). This feature allows saving the statistics when they are computed.
% NB The double handle is necessary as the call may occur from two different windows (the main and the
% one created by Model_PARAFAC\PARAFACPlotControls).
% 
% Inputs: 
% FigHandle: handle to the figure with the ModelOut structure
% MainFig: if not inserted is set to FigHandle. Otherwise it is the handle to the main figure.
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% DefaultPlot, Model_PARAFAC\PARAFACActivatePlots, Model_PARAFAC\PARAFACPlotControls
% NB. The call is made from the base work-space and not from Model_PARAFAC\PARAFACActivatePlots. The
% latter function defines PARAFACPlot(MainFig) as the callback function for the plotting menus.
% 
% Subroutines:
% Internal: Nones
% External: checkplotstruct, parafacdisplayinfo, getcvdata, checkaxes
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:41:14
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

if ishandle(FigHandle)
   if nargin < 2 %The function is called from the main window
      MainFig = FigHandle;
   end 
   [ModelOut,PlotStruct] = getcvdata(FigHandle,'Results','PlotStr');   
elseif strcmp(FigHandle,'defaultplot')
   
   if nargin < 2 | ~isa(MainFig,'struct') 
      uiwait(warndlg('Something''s gone wrong!'))
   else %Default plot
      
      %Explained variance
      MF = findobj('type','figure','userdata','Cubatch');
      delete(findobj(MF,'type','axes','tag','cbaxes'))
      colormap jet
      Ax = Plot_Explained_Variance(MainFig(1).plot,MainFig(1),findobj('type','figure','userdata','Cubatch'));
      PARAFACDisplayInfo(findobj('type','figure','userdata','Cubatch'),getappdata(Ax,'ModelOut'))
      CheckAxes(MF)
      setappdata(MF,'PlotStr',MainFig(1).plot)
      
   end
   return
   
else 
   uiwait(warndlg('Something''s gone wrong!'))
   return
end
if isa(PlotStruct,'struct') %Draw new plot
   
   [PlotStruct] = CheckPlotStruct(PlotStruct,MainFig);
   figure(MainFig)
   delete(findobj(MainFig,'type','axes','tag','cbaxes'))
   if ~isempty(findobj(0,'type','figure','userdata','PARAFAC Plot Control')) & strcmp(get(gcbo,'type'),'uimenu')
      delete(findobj(0,'type','figure','userdata','PARAFAC Plot Control'))
   end
   colormap jet
   [Handle_Axes,MO] = feval(PlotStruct.type,PlotStruct,ModelOut,MainFig);
   if ~isempty(Handle_Axes)
      
      PARAFACDisplayInfo(MainFig,getappdata(Handle_Axes,'ModelOut'))
      CheckAxes(MainFig)
      setappdata(MainFig,'PlotStr',PlotStruct)
      if ~isempty(MO)
         setappdata(MainFig,'Results',MO);
      end
      
   end
   
   set(MainFig,'ResizeFcn','ResizeCuBatch(NaN);') %Bug fix for 6.1 if an object is edited this function name is lost...
   
end