function ModelIn = ParafacOptions(ModelIn)
% function ModelIn = PARAFACOptions (ModelIn);
% 
% Description:
% Opens the figures for setting the options relative to the fitting of the PARAFAC model: the standard
% and the advanced ones. Not all the options given by PAROptions can be set via this window. It handles
% as callback function all the events associated to these two windows.
% The following options (for their meaning see \private\PAROptions) are handled: 
% Standard:
%    gradconvcrit 
%    initialisation 
%    maxiter 
%    parconvcrit 
%    refmaxiter 
%    relfitconvcrit 
% Advanced
%    FRIN 
%    InitIter 
%    Large 
%    Line-search 
%    Tuckextra 
% The values are stored in ModelIn.options.algorithm.maxiter and ModelIn.options.algorithm.constants
% 
% Inputs: 
% ModelIn: ModelIn structure
% 
% 
% Outputs:
% ModelIn: ModelIn structure, if the buttons 'OK' or 'Close advanced' are not pressed and the windows
%          are closed otherwise, ModelIn is returned empty.
% 
% 
% Called by:
% Model_PARAFAC\PARAFACModel
% 
% Subroutines:
% Internal: None
% External: setcvdata, cenwindow, ctag, cval, getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 10-Jun-2002 11:06:52
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GuiNames
if isa(ModelIn,'struct')
   cbf = 'ParafacOptions(NaN);';
   h   = CenWindow(WIC,'PARAFAC Options',cbf,490,217);
   set(h,'toolbar','none')
   Han(15) = uicontrol(ty,fr,pos,[  7   6 336 206],bg,FRC);
   %Initialsation
   InitSt  = {'random','orth','nipals','dtld','swatld','best'};
   Han(1)  = uicontrol(ty,tx,pos,[ 10 179 100  25],st,'Initialisation',ari{:},bg,FRC,bd{:},ha,'left');
   Han(2)  = uicontrol(ty,pu,pos,[110 177 130  30],st,InitSt,ari{:},tg,'initialise',cb,cbf,bg,'w',ud,4,va,ModelIn.options.algorithm.constants(4));
   %Convergence criteria
   Han(3)  = uicontrol(ty,tx,pos,[ 10 145 200  25],st,'Convergence criteria',ari{:},bg,FRC,bd{:},ha,'left');
   Han(4)  = uicontrol(ty,tx,pos,[ 10 116 100  25],st,'Fit',bg,FRC,ari{:});
   Han(5)  = uicontrol(ty,ed,pos,[110 114  60  30],st,sprintf('%1.0e',ModelIn.options.algorithm.constants(1)),ari{:},bg,'w',cb,cbf,tg,'convcrit',ud,1);
   Han(6)  = uicontrol(ty,tx,pos,[180 101 100  45],st,'Parameter''s update',ari{:},bg,FRC);
   Han(7)  = uicontrol(ty,ed,pos,[280 114  60  30],st,sprintf('%1.0e',ModelIn.options.algorithm.constants(2)),ari{:},bg,'w',cb,cbf,tg,'convcrit',ud,2);
   Han(8)  = uicontrol(ty,tx,pos,[ 10  80 100  25],st,'Gradient',ari{:},bg,FRC);
   Han(9)  = uicontrol(ty,ed,pos,[110  78  60  30],st,sprintf('%1.0e',ModelIn.options.algorithm.constants(3)),ari{:},bg,'w',cb,cbf,tg,'convcrit',ud,3);
   %Max iter
   Han(10) = uicontrol(ty,tx,pos,[ 10  42 130  25],st,'Iteration limits',bg,FRC,ari{:},bd{:},ha,'left');
   Han(11) = uicontrol(ty,tx,pos,[ 10  12 100  25],st,'Fitting',ari{:},bg,FRC);
   Han(12) = uicontrol(ty,ed,pos,[110  10  60  30],st,sprintf('%i',ModelIn.options.algorithm.maxiter(1)),cb,cbf,ari{:},bg,'w',tg,'maxiter',ud,1);
   Han(13) = uicontrol(ty,tx,pos,[170  12 100  25],st,'Refining',bg,FRC,ari{:});
   Han(14) = uicontrol(ty,ed,pos,[270  10  60  30],st,sprintf('%i',ModelIn.options.algorithm.maxiter(2)),cb,cbf,ari{:},bg,'w',tg,'maxiter',ud,2);
   Han(16) = uicontrol(ty,ps,pos,[350  82 130  30],st,'Advanced',cb,cbf,tg,'advanced',ari{:});
   Han(17) = uicontrol(ty,ps,pos,[350  46 130  30],st,'Cancel',cb,cbf,tg,'end main',ari{:});
   Han(18) = uicontrol(ty,ps,pos,[350  10 130  30],st,'OK',cb,cbf,tg,'ok',ari{:});
   %Advanced
   HanAdv(1) = uicontrol(ty,tx,pos,[ 10 115 100 25],st,'Init. Max. Iter',ari{:},bg,WIC);
   HanAdv(2) = uicontrol(ty,ed,pos,[110 113  50 30],st,sprintf('%i',ModelIn.options.algorithm.maxiter(3)),cb,cbf,ari{:},bg,'w',tg,'maxiter',ud,3);
   HanAdv(3) = uicontrol(ty,ch,pos,[220 118 100 30],st,'FRIN',cb,cbf,ari{:},bg,WIC,va,ModelIn.options.algorithm.constants(5),tg,'constants',ud,5);
   HanAdv(4) = uicontrol(ty,ch,pos,[220  82 130 30],st,'Large J filling',cb,cbf,ari{:},bg,WIC,va,ModelIn.options.algorithm.constants(8),tg,'constants',ud,8);
   HanAdv(5) = uicontrol(ty,tx,pos,[ 10  74 100 25],st,'Line-search',ari{:},bg,WIC);
   HanAdv(6) = uicontrol(ty,pu,pos,[110  72 100 30],st,{'None','Iteration','Divergence'},ari{:},bg,'w',cb,cbf,va,ModelIn.options.algorithm.constants(6),tg,'linesearch',ud,6);
   HanAdv(7) = uicontrol(ty,tx,pos,[ 10  22 100 45],st,'Comp. extra factors',ari{:},bg,WIC);
   HanAdv(8) = uicontrol(ty,ed,pos,[110  35  59 30],st,sprintf('%i',ModelIn.options.algorithm.constants(9)),bg,'w',cb,cbf,ari{:},tg,'tuckextra');
   HanAdv(9) = uicontrol(ty,ps,pos,[220  10 130 30],st,'Close advanced',cb,cbf,ari{:},tg,'end advanced');
   setcvdata(h,'ModelIn',ModelIn,'Handlers',Han,'AdvHandlers',HanAdv)
   set(HanAdv,off{:})
   if strcmp(ModelIn.options.algorithm.name,'ALS')
      set(Han([6:9 13 14]),dis{:})
      set(HanAdv([3:8]),dis{:})
   elseif strcmp(ModelIn.options.algorithm.name,'gGN')
      set(Han(:),en{:})
      set(HanAdv(:),en{:})
   end
   if ~ModelIn.options.algorithm.constants(7)
      set(Han([13 14]),dis{:})
      set(HanAdv(7:8),dis{:})
   else
      set(Han([13 14]),en{:})
      set(HanAdv(7:8),en{:})
   end
   waitfor(h,'waitstatus','close')
   ModelIn = getappdata(h,'ModelIn');
   delete(h)
else
   [ModelIn,Han,HanAdv] = getcvdata(gcbf,'ModelIn','Handlers','AdvHandlers');
   switch ctag
   case {'window','end main'}
      setappdata(gcbf,'ModelIn',[])
      set(gcbf,'waitstatus','close')
      
   case 'end advanced'
      set(Han,on{:})
      set(HanAdv,off{:})
      P = get(gcbf,pos);
      set(gcbf,pos,[P(1) P(2) - 62 490 217],'name','PARAFAC Options')
      
   case 'advanced'
      set(Han,off{:})
      set(HanAdv,on{:})
      P = get(gcbf,pos);
      set(gcbf,pos,[P(1) P(2) + 62 360 155],'name','PARAFAC Advanced Options')
      
   case {'convcrit','tuckextra'}
      a = sscanf(get(gcbo,st),'%f');
      if ~isempty(a)
         ModelIn.options.algorithm.constants(get(gcbo,ud)) = a;
         setappdata(gcbf,'ModelIn',ModelIn)
      end
      
   case 'maxiter'
      a = sscanf(get(gcbo,st),'%i');
      if ~isempty(a)
         ModelIn.options.algorithm.maxiter(get(gcbo,ud)) = a;
         setappdata(gcbf,'ModelIn',ModelIn)
      end
      
   case {'constants','linesearch','initialise'}
      ModelIn.options.algorithm.constants(get(gcbo,ud)) = cval;
      setappdata(gcbf,'ModelIn',ModelIn)
      
   case 'ok'
      set(gcbf,'waitstatus','close')
      
   otherwise
      uiwait(msgbox('You haven''t implemented yet!'))
      
   end
end

%------------------------------------------------------------------------------------------------------------------------------

