function [ModelIn,ModelOut] = PARAFACModel(ModelIn)
% function [ModelIn,ModelOut] = PARAFACModel (ModelIn);
% 
% Description:
% Creates a figure and handles the corresponding events for computing a PARAFAC using the selected
% variables in X. If the 'Cancel' button is pressed ModelIn is returned empty.
% 
% Inputs: 
% ModelIn: ModelIn structure
% 
% 
% Outputs:
% ModelIn: ModelIn structure
% ModelOut: ModelOut structure
% 
% Called by:
% Dispatch_Compute
% 
% Subroutines:
% Internal: None
% External: calculate, initmodelin, check, defcontrols, parafacconstraints, parafacoptions, guinames,
%           setcvdata, cenwindow, ctag, cval, getcvdata, preprocess
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 13-Nov-2002 21:12:32
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%


GuiNames

if isa(ModelIn,'struct')
   
   X       = getappdata(ModelIn.xpointer,'X');
   SizeX   = size(X{1});
   clear X
   a       = perms(1:length(SizeX));
   f       = SizeX(a);
   f       = min(prod(f(:,2:end),2)); %for Kruskal, it is defined for 3 way arrays only. Here is 
                                      %extended as a limit for the number of factor for any nway array
   h       = cenwindow(WIC,'PARAFAC Model','PARAFACModel(NaN);',385,238);
   set(h,'toolbar','none',ud,f)
   ModelIn = InitModelIn(ModelIn);
   CVHan   = DefControls(h,ModelIn);
   Check(ModelIn,CVHan)
   % temporary
   set([CVHan.segments,CVHan.segmed],off{:})
   % end
   setcvdata(h,'Handles',CVHan,'Results',[],'Model',ModelIn)
   waitfor(h,'waitstatus','close')
   [ModelIn,ModelOut] = getcvdata(h,'Model','Results');
   delete(h)
   
else
   
   [CVHan,ModelIn] = getcvdata(gcbf,'Handles','Model');
   Set             = [];
   switch ctag
   case {'nboo','test','loo'}
      ModelIn.valmethod.name = ctag;
      set(CVHan.meth(CVHan.meth ~= gcbo),va,0)
      set(gcbo,va,1)
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'AlgOpt'
      M = PARAFACOptions(ModelIn);
      if ~isempty(M)
         setcvdata(gcbf,'Model',M)
      end
      
   case 'AlgChoice'
      ModelIn.options.algorithm.name = get(gcbo,ud);
      setcvdata(gcbf,'Model',ModelIn)
      %set(allchild(get(gcbo,'parent')),cof{:})
      %set(gcbo,con{:})
      
   case 'BooChoice'
      ModelIn.valmethod.name = get(gcbo,ud);
      setcvdata(gcbf,'Model',ModelIn)
      %set(allchild(get(gcbo,'parent')),cof{:})
      %set(gcbo,con{:})
      
   case 'Compress'
      if strcmp(get(gcbo,cc),'on')
         ModelIn.options.algorithm.constants(7) = 0;
      else
         ModelIn.options.algorithm.constants(7) = 1;
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'window'
      setcvdata(gcbf,'Model',[],'Results',[])
      set(gcbf,'waitstatus','close')
      return
      
   case 'End'   
      set(gcbf,'waitstatus','close')
      
   case 'Factors'
      try
         
         Str = get(CVHan.facted,st);
         if any(Str==',')
            
            a(1) = sscanf(Str(1:min(find(Str == ','))),'%i')';
            a(2) = sscanf(Str(min(find(Str == ',')) + 1:end),'%i')';
            if any(a > get(gcbf,ud))
               errordlg('The number of factors is too high','Too many factors')
               a = [];
            end
            if length(a) == 2
               ModelIn.nbfactors.min = a(1);
               ModelIn.nbfactors.max = a(2);
            end
            set(CVHan.facted,st,sprintf('%i , %i',ModelIn.nbfactors.min,ModelIn.nbfactors.max))
            
         else
            a = sscanf(Str,'%i')';
            b = [];
            if ~isempty(a)
               if (a > get(gcbf,ud))
                  errordlg('The number of factors is too high','Too many factors')
                  a = ModelIn.nbfactors.min;
                  b = ModelIn.nbfactors.max;
               end
               ModelIn.nbfactors.max = b;
               ModelIn.nbfactors.min = a;
            end
            set(CVHan.facted,st,sprintf('%i',ModelIn.nbfactors.min))
         end
         
      catch
         set(CVHan.facted,st,'')
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'replica'
      try
         ModelIn.valmethod.replicates = sscanf(get(CVHan.repled,st),'%i');
      catch
         set(CVHan.repled,st,'')
         return
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'segments'
      try
         ModelIn.valmethod.segments = sscanf(get(CVHan.segmed,st),'%i');
      catch
         set(CVHan.segm,st,'')
         return
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'validate'
      if ~cval
         ModelIn.valmethod = struct('bootstrap',[],'name',[],'replicates',[],'segments',[]);
      else
         ModelIn.valmethod = struct('bootstrap',[],'name','loo','replicates',[],'segments',[]);
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'PreTreat'
      ModelIn = PreProcess(ModelIn,0);
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'Const'
      ModelIn = PARAFACConstraints(ModelIn);
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'StartBut'
      ModelOut = Calculate(ModelIn);
      setcvdata(gcbf,'Results',ModelOut)
      set(gcbf,'waitstatus','close')
      
   case 'Help'
      a   = lower(which('CuBatch'));
      a   = strrep(a,'cubatch.m','Help\user\win\winparafac.html');
      stat=web(['file:///' a],'-browser');
   
   end   
   ModelIn = getcvdata(gcbf,'Model');
   Check(ModelIn,CVHan)
   set([CVHan.segments,CVHan.segmed],off{:})
end
