function Predictions = PARAFACPred(X,Model_Parameters,varargin)
% function Predictions = PARAFACGNPred (X,Model_Parameters,varargin);
% 
% Description:
% Applies a PARAFAC model to the data contained in X. The model is defined by Model_Parameters. It is
% PARAFAC PredFun when this model is computed using a GN function. NB. Currently it produces results
% identical from those obtained with PARAFACPred.
% 
% Inputs: 
% X               : double array of data
% Model_Parameters: ModelOut.model structure or cell vector of doubles
% varargin        : additional inputs for the parafac function (i.e. Options, Constraints, etc); some
%                   of these are not available (e.g. the modes not referring to the samples are fixed).
% 
% Outputs:
% Predictions: structure with two fields
%              - xfactors, matrix of doubles with the new scores 
%              - xpred, predictions for X.
% 
% Called by:
% Model_PARAFAC\Calculate
% 
% 
% Subroutines:
% Internal:None
% External: nmodel, parafac
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 12-Jun-2002 00:21:42
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if isa(Model_Parameters,'struct')
   F                = Model_Parameters.nbfactors;
   Model_Parameters = Model_Parameters.xfactors;
else
   F = size(Model_Parameters{1},2);
end
Ain                  = zeros(size(X,1),F);
[varargin{3:4}]      = deal([{Ain},Model_Parameters(2:end)],[0 ones(1,ndims(X)-1)]);
varargin{1}([1 2 6]) = varargin{1}([2 5 11]);
varargin{1}([3 4 5]) = [0 0 NaN];
varargin{1}          = varargin{1}(1:6);
Factors              = parafac(X,F,varargin{:});
Predictions.xpred    = nmodel(Factors);
Predictions.xfactors = Factors{1};