function Model_Parameters = ParafacFit(X,F,varargin)
% function Model_Parameters = PARAFACGNFit (X,F,varargin);
% 
% Description:
% Fit_Fun (see FitModel) fitting the PARAFAC model to the array X when compression or the dGN algorithm
% are required.
% 
% Inputs: 
% X       : array of data (currently limited to 3-ways)
% F       : number of components to extract.
% varargin: the additional inputs (beside X and F) for the genparafac function.
% 
% 
% Outputs:
% Model_Parameters: structure with three fields
% 
% xfactors  : cell vector with the loading matrices 
% nbfactors : F 
% iterations: number of iterations for fitting (Model_Parameters.iteration(1)) and refining  (Model_Parameters.iteration(2)) 
% 
% Called by:
% Model_PARAFAC\Calculate
% 
% Subroutines:
% Internal: None
% External: genparafac, paroptions
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 10-Jun-2002 18:34:16
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if length(varargin) >= 3
   if ~isempty(varargin{3}) & isa(varargin{3},'cell')
      if size(X,1) ~= size(varargin{3}{1},1)
         varargin{3}{1} = rand(size(X,1),F);
      end
   end
end
Options = varargin{1};
Opt1    = num2cell(Options(2:end));
Opt     = [{'relfitconvcrit',...
            'parconvcrit',...
            'gradconvcrit',...
            'initialisation',...
            'frin',...
            'linesearch',...
            'compression',...
            'large',...
            'tuckextra',...
            'maxiter',...
            'refmaxiter',...
            'inititer'}',...
            Opt1(:)]';
Init    = {'random','orth','nipals','dtld','swatld','best'};
Opt(2,4) = Init(find(1:6 == Options(5)));
Opt(2,5) = {deblank(char('on ' * Options(6) + 'off' * (~Options(6))))};
Opt(2,6) = {deblank(char('none  ' * (Options(7) == 0) + 'iter  ' * (Options(7) == 1) + 'diverg' * (Options(7) == 2)))};
Opt(2,7) = {deblank(char('on ' * Options(8) + 'off' * (~Options(8))))};
Opt(2,8) = {deblank(char('on ' * Options(9) + 'off' * (~Options(9))))};
OptFin   = ParOptions(Opt{:},'display','none','diagnostics','off');
%Actually fit the model
Model_Parameters.nbfactors                                       = F;
[Model_Parameters.xfactors{1:3},Nil,Model_Parameters.iterations] = ...
         genparafac(X,F,OptFin,Options(1),varargin{end}); %constraints are ignored
if ~Options(7)
   
   if Options(1)
      Model_Parameters.iterations = Model_Parameters.iterations(2);
   else
      Model_Parameters.iterations = Model_Parameters.iterations(1);
   end
end
