function Model_Parameters = ParafacFit(X,F,varargin)
% function Model_Parameters = PARAFACFit (X,F,varargin);
% 
% Description:
% Fit_Fun fitting the PARAFAC model to the array X using an ALS algorithm (the NWay toolbox
% implementation). See FitModel.
% 
% Inputs: 
% X: double array of data
% F: number of components to extract.
% varargin: the additional inputs (beside X and F) for the parafac function ..\Nway\PARAFAC.m (i.e. Options, Constraints, etc).
% 
% 
% Outputs:
% Model_Parameters: structure with three fields 
%                        xfactors  : cell vector with the loading matrices
%                        nbfactors : F 
%                        iterations: number of iterations for fitting (Model_Parameters.iteration(1))
%                                    and refining  (Model_Parameters.iteration(2))
% Called by:
% Model_PARAFAC\Calculate via ValidateModel and FitModel 
% 
% Subroutines:
% Internal: None
% External: NWay\parafac
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-May-2002 16:14:44
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if length(varargin) >= 3
   if ~isempty(varargin{3}) & isa(varargin{3},'cell')
      if size(X,1) ~= size(varargin{3}{1},1)
         varargin{3}{1} = rand(size(X,1),F);
      end
   end
end
Model_Parameters.nbfactors                              = F;
[Model_Parameters.xfactors,Model_Parameters.iterations] = parafac(X,F,varargin{:});
