function ModelIn = PARAFACConstraints(ModelIn)
% function ModelIn = PARAFACConstraints (ModelIn);
% 
% Description:
% It opens a window for setting the constraints for fitting a PARAFAC model (this window is available
% only if compression is not applied and not for the LM algorithm). The constraints currently available
% for PARAFAC are: 'none', 'orthogonality', 'nonnegativity', 'unimodality' (see the NWay/PARAFAC help).
% Only one type of constraint is possible per mode. The selections are stored in ModelIn.constraints.
% 
% Inputs: 
% ModelIn: ModelIn structure
% 
% 
% Outputs:
% ModelIn: ModelIn structure, if the button 'OK' is not pressed and the figure is closed otherwise, ModelIn is returned empty.
% 
% 
% Called by:
% Model_PARAFAC\PARAFACModel
% 
% Subroutines:
% Internal: None
% External: setcvdata, cenwindow, ctag, cval, getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 26-Oct-2002 17:34:20
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GuiNames

if isa(ModelIn,'struct')
   % Constr      = struct('modes',[],'constants',[],'core',[],'factors',[],'name',[]);.
   % Data        = struct('augmentedmatrix',[],'initialinput',[],'sam',[],'samlabs',[],'var',[]);
   % Fact        = struct('min',[],'max',[]); .
   % Options     = struct('algorithm',struct('constants',[],'maxiter',[],'name',[],'value',[]),'species',[],'direction',[]);
   % ValMethod   = struct('bootstrap',[],'name',[],'replicates',[],'segments',[]);
   % ModelIn     = struct('constraints',Constr,'data',Data,'file',[],'modelname',[],'nbfactors',Fact,'options',Options,'valmethod',ValMethod,'sam',ModelIn.sam,'samlabs',ModelIn.samlabs,'var',ModelIn.var); 
   Const = {'None','Non-negativity','Orthogonality','Unimodality'};
   [a,Pos_Exist_Const] = intersect({ModelIn.constraints.name},lower(Const));
   ConstStat = cat(1,ModelIn.constraints.modes);
   cbf  = 'PARAFACConstraints(NaN);';
   FrH  = 25 * (length(ModelIn.var(1).cen) + 1) + 56; 
   h    = CenWindow(WIC,'PARAFAC Constraints',cbf,430, FrH + 14);
   set(h,'toolbar','none')
   Base = length(ModelIn.var(1).cen)* 25 + 10;
   uicontrol(ty,fr,pos,[  7     7 276 FrH],bg,FRC)
   if ~isempty(find(ConstStat(:,1)))
      a = find(Pos_Exist_Const == find(ConstStat(:,1)));
   else
      a = 0;
   end
   if isempty(a)
      a = 0;
   end
   uicontrol(ty,pu,pos,[150 Base     130  25],st,Const,cb,cbf,tg,'Constraint',ari{:},bg,wh,va,a + 1,ud,1);
   uicontrol(ty,tx,pos,[ 10 Base - 2 130  25],st,'Batches',ari{:},bg,FRC,ud,1)
   for i = 1:length(ModelIn.var(1).cen)
      if ~isempty(find(ConstStat(:,1)))
         a = find(Pos_Exist_Const == find(ConstStat(:,i + 1)));
      else
         a = 0;
      end
      if isempty(a)
         a = 0;
      end
      uicontrol(ty,pu,pos,[150 Base - 25 * i     130 25],st,Const,cb,cbf,tg,'Constraint',ari{:},bg,wh,va,a + 1,ud,i + 1)
      uicontrol(ty,tx,pos,[ 10 Base - 25 * i - 2 130 25],st,ModelIn.var(1).sel{i}.name.or,ari{:},bg,FRC,ud,i + 1)
   end
   uicontrol(ty,tx,pos,[10  Base + 50 270 25],st,'X',ha,'center',ari{:},bd{:},fs,13,bg,FRC)
   uicontrol(ty,tx,pos,[150 Base + 25 130 25],st,'Constraint',ha,'center',ari{:},bd{:},fs,12,bg,FRC)
   uicontrol(ty,tx,pos,[ 10 Base + 25 130 25],st,'Mode',      ha,'center',ari{:},bd{:},fs,12,bg,FRC)
   uicontrol(ty,ps,pos,[290        10 130 30],st,'Ok',cb,cbf,tg,'Ok',ari{:})
   uicontrol(ty,ps,pos,[290        46 130 30],st,'Cancel',cb,cbf,tg,'window',ari{:})
   setcvdata(h,'Model',ModelIn);
   waitfor(h,'waitstatus','close')
   ModelIn = getcvdata(h,'Model');
   delete(h)
   return
else
   ModelIn = getcvdata(gcbf,'Model');
   Const = {'None','Non-negativity','Orthogonality','Unimodality'};
   [a,Pos_Exist_Const] = intersect({ModelIn.constraints.name},lower(Const));
   ConstStat = cat(1,ModelIn.constraints.modes);
   switch ctag
   case 'Ok'
      set(gcbf,'waitstatus','close')
      
   case 'window'
      setcvdata(gcbf,'Model',[])
      set(gcbf,'waitstatus','close')
      
   case 'Constraint'
      for i = 1:length(Pos_Exist_Const)
         ModelIn.constraints(Pos_Exist_Const(i)).modes(get(gcbo,ud)) = 0;
      end
      if cval - 1;
         ModelIn.constraints(Pos_Exist_Const(cval - 1)).modes(get(gcbo,ud)) = 1;
      end
   end
   setcvdata(gcbf,'Model',ModelIn);

end