function ModelOut  = PARAFACApply(MainFig);
% function ModelOut = PARAFACApply (MainFig);
% 
% Description:
% Applies a certain PARAFAC model (that have just been calculated or loaded) to a new set of data. The
% new data is loaded via the load_extdata function. If more than one model is available a listbox
% requester appears requesting selection (which is permanent for the current session - i.e. the
% ModelOut.model and ModelOut.validation hold in the memory contain only the chosen model) of the
% model's complexity. The results are saved in the 'prediction' field of ModelOut.
% 
% Inputs: 
% MainFig: main CuBatch window handle.
% 
% 
% Outputs:
% ModelOut: ModelOut structure (it can be modified depending on the selection, see Description)
% 
% 
% Called by:
% Dispatch_Apply
% 
% Subroutines:
% Internal: None
% External: applymodel, load_extdata, parafacpred
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 27-Oct-2002 00:20:56
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

ModelOut           = getappdata(MainFig,'Results');
MO                 = ModelOut;
Pos                = 1;
Ans                = 'Yes';
if length(MO.model) ~= 1
   ListProp = {'selectionmode','single','name','Choose model','promptstring',{'You have more than one model','Select the one to apply'}};
   ReqTit   = 'Choose model';
   Ranks    = [MO.model.nbfactors]';
   [Pos,Ok] = listdlg('Liststring',cellstr(num2str(Ranks)),ListProp{:});
   if ~Ok,return,end
   if strcmp(getappdata(MainFig,'Mode'),'advanced')
      QuestOptions = struct('Interpreter','tex','Default','Yes');
      Prompt       = {'The choice eliminates the other dimensionalities.';...
            'Do you wish to continue?';...
            'NB: the removal affects \bfonly\rm in the current session'};
      Ans          = questdlg(Prompt,'Continue','Yes','No',QuestOptions);
      if strcmp(Ans,'No'),return,end
   end
end
MO.model = MO.model(Pos);
if ~isempty(MO.validation)
   MO.validation = MO.validation(Pos);
end
try
   [Stat,MO] = Load_ExtData(MO,MainFig);
catch
   uiwait(errordlg(lasterr))
   return
end
if Stat
   
   Constraints = ModelOut.info.constraints;
   switch ModelOut.info.algorithm
      case 'ALS'
         Constraints = ModelOut.info.constraints;
      case 'dGN'
         Constraints = zeros(1,ndims(MO.prediction.data.data));
   end
   MO.prediction    = ApplyModel('parafacpred',MO.prediction.data.data,[],MO.model,MO.prediction,MO.info.initialsize,MO.info.fillin,[],Constraints);
   ModelOut         = MO;

else
   ModelOut = [];
end

return