function ActivatePlotsPARAFAC(PlotMenuHan,ModelOut)
% function PARAFACActivatePlots (PlotMenuHan,ModeNames,Factors,Validation,Flag);
% 
% Description:
% It activates the 'Results' submenus relative to a PARAFAC model after it is computed, loaded or
% applied to a new set of data via PARAFACApply. Some plots are available only for specific type of
% validation or whether the model is fit to a new set of data instead of being just computed. In
% particular the 'online' plots (Q statistics, D statistics, SPE) are activated only when the last mode
% is given name 'time' (case insensitive) The menus callback is PARAFACPlot
% 
% Inputs: 
% PlotMenuHan: 'Results' menu handle
% ModeNames  : cell vector holding the modes' names for the data used to compute the model
% Factors    : vector of the number of factors (for all the computed models, if more than one)
% Validation : type of validation
% Flag       : 0/1 depending on whether the results refer to a model that has been just computed (0) or
%              to a model that has been applied to a new set of data (1).
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% ActivatePlots
% 
% Subroutines:
% Internal: None
% External: guinames, setcvdata plot_d_statistic, plot_explained_variance, plot_imp, plot_landscape,
%           plot_loadings, plot_partial_rss, plot_partial_rss_online, plot_press, plot_quality,
%           plot_rip, plot_risk, plot_rmse,
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 19:45:38
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GuiNames
Factors    = [ModelOut.model.nbfactors];
Flag       = ~isempty(ModelOut.prediction);
ModeNames  = ModelOut.data.dataset.modenames;
Validation = '';
if ~isempty(ModelOut.validation)
   Validation = ModelOut.validation(1).method;
end

delete(get(PlotMenuHan,'children'));
MainFig = get(PlotMenuHan,'parent');
cbf     = sprintf('PARAFACPlot(%i);',MainFig);
%XMen    = uimenu(PlotMenuHan,la,'&Results',tg,'res');
h       = uimenu(PlotMenuHan,la,[' Loadings &1: ',ModeNames{1}],ud,1);
for i = 1:3 %min(3,Factors)
   if i > Factors
      sm(i,1) = uimenu(h,la,sprintf('Plots %iD',i),ud,i,cb,cbf,tg,'Plot_Loadings',dis{:});
   else
      sm(i,1) = uimenu(h,la,sprintf('Plots %iD',i),ud,i,cb,cbf,tg,'Plot_Loadings');
   end
end
b = [];
for i = 2:length(ModeNames)
   h = uimenu(PlotMenuHan,la,[' Loadings &',sprintf('%i: ',i),ModeNames{i}],ud,i);
   b(end + 1:end + length(sm),1) = copyobj(sm,h);
end
sm          = [sm;b];
if strcmpi(ModeNames{length(ModeNames)},'Time')
   H = uimenu(PlotMenuHan,la,'D-statistic',sep{:});
   sm(end + 1) = uimenu(H,la,'On-line',cb,cbf,tg,'Plot_D_Statistic',ud,'on');
   sm(end + 1) = uimenu(H,la,'Off-line',cb,cbf,tg,'Plot_D_Statistic',ud,'off');
else
   sm(end + 1) = uimenu(PlotMenuHan,la,'D-statistic',sep{:},cb,cbf,tg,'Plot_D_Statistic',ud,'off');
end
H = uimenu(PlotMenuHan,la,'D-Contribution',dis{:});
for i = 2:length(ModeNames)
   sm(end + 1) = uimenu(H,la,['Mode &',sprintf('%i: ',i),ModeNames{i}],cb,cbf,tg,'Plot_D_Contribution',ud,i);
end   

if any(strcmp({'loo','nboo','rboo'},Validation))
   if strcmp({'loo'},Validation)
      sm(end + 1) = uimenu(PlotMenuHan,la,'Identity Match Plot',cb,cbf,tg,'Plot_IMP',sep{:});
      H = uimenu(PlotMenuHan,la,'Resample Influence Plot');
      for i = 2:length(ModeNames)
         uimenu(H,la,['Mode &',sprintf('%i: ',i),ModeNames{i}],cb,cbf,tg,'Plot_RIP',ud,i);
      end
   end
   if length(Factors) > 1
      sm(end + 1) = uimenu(PlotMenuHan,la,'Ris&k',cb,cbf,tg,'Plot_Risk');
      if ~strcmp({'loo'},Validation)
         set(sm(end),sep{:})
      end
   end
end
a(3)        = uimenu(PlotMenuHan,la,'&Expl. var.',sep{:});
sm(end + 1) = uimenu(PlotMenuHan,la,'&PRESS',     cb,cbf,tg,'Plot_PRESS');
sm(end + 1) = uimenu(PlotMenuHan,la,'&RMSE',      cb,cbf,tg,'Plot_RMSE');
a(1) = uimenu(PlotMenuHan,la,'Re&siduals',sep{:});
a(2) = uimenu(PlotMenuHan,la,'&Congruence');
for i = 1:length(ModeNames)
   sm(end + 1) = uimenu(a(1),la,['Mode &',sprintf('%i: ',i),ModeNames{i}],cb,cbf,tg,'Plot_Partial_RSS',ud,{i,'Residuals'});
   if i == length(ModeNames) & strcmpi(ModeNames{i},'Time')
      Handle = sm(end);
      sm(end + 1) = uimenu(Handle,la,'On line',cb,cbf,tg,'Plot_Partial_RSS_OnLine',ud,'Q');
      sm(end + 1) = uimenu(Handle,la,'Off line',cb,cbf,tg,'Plot_Partial_RSS',ud,{i,'Residuals'});
      sm(end + 1) = uimenu(Handle,la,'SPE',cb,cbf,tg,'Plot_Partial_RSS_OnLine',ud,'SPE');
      set(Handle,cb,'')
   end
   sm(end + 1) = uimenu(a(2),la,['Mode &',sprintf('%i: ',i),ModeNames{i}],cb,cbf,tg,'Plot_Partial_RSS',ud,{i,'Congruence'});
   sm(end + 1) = uimenu(a(3),la,['Mode &',sprintf('%i: ',i),ModeNames{i}],cb,cbf,tg,'Plot_Partial_RSS',ud,{i,'% Var'});
end
sm(end + 1) = uimenu(a(3),la,'&Global',cb,cbf,tg,'Plot_Explained_Variance',sep{:});
if length(ModeNames) < 4;
   sm(end + 1) = uimenu(a(1),la,'&Landscape',cb,cbf,tg,'Plot_Landscape',ud,'Residuals',sep{:});
   sm(end + 1) = uimenu(PlotMenuHan,la,'&Model landscape',    cb,cbf,tg,'Plot_Landscape',ud,'Model',sep{:});
end
setcvdata([sm;a(:)],'Apply',Flag)
