function [B,err,PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = regressvcacpVI(Y,X,rx,ryvi,algo,opti);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% regressacpVI                                       %
%[PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] =                  %
%               regressvcacpVI(Y,X,rx,ryvi,pro,cent);  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rx: dimensions of the subspaces 
%             obtained by pca of X
%     ryvi: dimension of pca
%             for PxY
%     pro:2-vector corresponding to the 2 modes
%             1 if we want to project Y along the 
%                 corresponding mode.
%             0 if not.
%      cent=1 means centering (if not, 0 (default))
% OUTPUTS
%     B regression coefficient matrix
%     err  error of prediction by cross validation
%     PxY   the projected of Y on X.
%     vexpvi:Explained variation
%     Avi,Bvi:score and loadings of pca(PxY).
%     vexpX:  explained variation of X.
%     Ax,Bx:loadings of tucker(X).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes and       %
%   cross validation in order to estimate           %
%   the accurate of prediction                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    acpVIf                                          %
%    predicacpVI                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   18/12/2001   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[nx,px]=size(X);
[ny,py]=size(Y);

%erreur de format
if ~isequal(nx,ny) 
   error('X and Y must have the same number of lines');
end;
n=nx;
err=0;
for i=1:n,
   Xvc=X([1:i-1,i+1:n],:);
   x=X(i,:);
   Yvc=Y([1:i-1,i+1:n],:);
   y=Y(i,:);
   [B,PxY,vexpvi,Avi,Byvi,vexpX,Ax,Bx] = acpVIf(Yvc,Xvc,rx,ryvi,algo,opti);
   [ypred] = predicacpVI(x,B,Byvi,Bx);
   err(i)=100*sum((ypred'-y).^2)/sum((y.^2));
end;
err=mean(err);
[B,PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = acpVIf(Y,X,rx,ryvi,algo,opti);
