function [ypred] = predicacpVI(x,B,Byvi,Bx);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predicacpVI                                        %
% [ypred] = predicacpVI(x,B,Byvi,Bx);                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     x :  p-vector
%     B:regression coefficient matrix (pq-matrix)
%     Bx: loadings of X
% OUTPUTS
%     y predicted vector (q-vector)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Predicts a vector y with a regressed vector x    %
%  with PCA-IV                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regression2D                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   18/12/2001   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[m,mm]=size(x);
if isequal(m,1),
   x=x';
end;
%X size n*p, x size p*1

%projection de x sur col[Bx]
[PxY,b]=regression2D(x,Bx);
x=b;  %x size (1*rx)


%prdiction de y (rgression multilinaire)
y=x'*B;


% projection de y sur col(Byvi)
ypred=Byvi*inv(Byvi'*Byvi)*Byvi'*y';









   