function [err,rx,ryvi] = pcavival(Y,X,mi,mo,c);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pcavival                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rxmax: maximal dimensions of the subspaces 
%             obtained by pca of X
%     ryvimax: maximal dimension of pca for PxY
%      cent=1 means centering (if not, 0 (default))
% OUTPUTS
%     err  error of prediction by cross validation 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes and       %
%   cross validation in order to estimate           %
%   the accurate of prediction                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regressvcacpVI                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   20/12/2001   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
wic=[0.5029 0.5814 0.6402];
lbc=[0.9 0.93 0.95];
frc=[0.3529 0.4314 0.4902];

Rx=size(X);
Ry=size(Y);
algo=mi.options.algorithm.name;
fx=mi.nbfactors.max;
fy=mi.nbfactors.min;
opti=struct('tol',mi.options.algorithm.value,'maxit',mi.options.algorithm.maxiter,'disp',0);
if fx>min(Rx),
   uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Rx)),'.']}));
   return;
end;
if fy>min(Ry),
   uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Ry)),'.']}));
   return;
end;




mo.validation.xfactors{1}=zeros(Rx(1)-1,fx,Rx(1));
mo.validation.xfactors{2}=zeros(Ry(1)-1,fx,Rx(1));
mo.validation.core=zeros(fx,fx,Rx(1));
mo.validation.xev=zeros(fx,Rx(1));


% cv
err=zeros(fx,fy,Rx(1));
tic
for i=1:Rx(1),   % truncated X
   Xvc=X([1:i-1,i+1:Rx(1)],:);
   x=X(i,:);
   Yvc=Y([1:i-1,i+1:Rx(1)],:);
   y=Y(i,:);
   [Ux,Sx,Vx,mo.validation.xev(:,i)]=acpf(Xvc,fx,algo,opti);
	for k=1:fx,
      [PxYc,Bc]=regression2D(Yvc,Ux(:,1:k)*Sx(1:k,1:k));
   	  [U,S,Vyvi,vexpvi]=acpf(PxYc,fy,algo,opti);
   	  for j=1:fy,
         [ypred] = predicacpVI(x,Bc,Vyvi(:,1:j),Vx(:,1:k));
         err(k,j,i)=100*sum((ypred'-y).^2)/sum((y.^2));
      end;
   end;
end;
err=mean(err,3);
toc


% naive bootstrap
%nbboot=mi.valmethod.replicates;
%[bootstat, bootsam] = bootstrpanadon(nbboot,nsortie,'ACP',varargin)



hfig=1;
h1=uicontrol('parent', hfig,...
   'backgroundcolor',frc,...
   'position',[10 20 180 460],...
   'tag','textfig',...
   'tooltipstring','',...  
   'style','frame');  
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Data X:',c{1}.name],...
   'fontweight','demi',...
   'fontsize',12,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 450 160 20],...
   'tooltipstring',['Author: ',c{1}.author],...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Size: [',int2str(c{1}.dims),']'],...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 430 120 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Description: ',c{1}.description],...
   'fontweight','normal',...
   'horizontalalignment','left',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'position',[15 410 160 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Data Y:',c{2}.name],...
   'fontweight','demi',...
   'fontsize',12,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 380 160 20],...
   'tooltipstring',['Author: ',c{2}.author],...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Size: [',int2str(c{2}.dims),']'],...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 360 120 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Description: ',c{2}.description],...
   'fontweight','normal',...
   'horizontalalignment','left',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'position',[15 340 160 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Validation of PCA'],...
   'fontweight','demi',...
   'fontsize',12,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 300 160 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Algorithm: ',algo],...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 280 120 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Number of PC X: [1... ',int2str(mi.nbfactors.max),'].'],...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 260 170 20],...
   'tooltipstring','',...  
   'style','text');
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',['Number of PC Y: [1... ',int2str(mi.nbfactors.min),'].'],...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'horizontalalignment','left',...
   'position',[15 240 170 20],...
   'tooltipstring','',...  
   'style','text');
pre='No preprocessing';
if mi.sam.cen==1,
   pre='Centered';
elseif mi.sam.scal==1
   pre='Scaled';
end;
if mi.sam.cen==1 & mi.sam.scal==1,
   pre='Auto-scaled';
end;
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',pre,...
   'fontweight','normal',...
   'horizontalalignment','left',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'position',[15 220 170 20],...
   'tooltipstring','',...  
   'style','text');
if strcmp(mi.valmethod.name,'nboo'),
   tex='Naive bootstrap';
   tool='';
elseif strcmp(mi.valmethod.name,'rboo'),
   tex='Residual bootstrap';
   tool='';
elseif strcmp(mi.valmethod.name,'cv'),
   tex='Cross Validation';
   tool='1 by 1 cross validation';
end;
h1=uicontrol('parent', hfig,...
   'tag','textfig',...
   'string',tex,...
   'horizontalalignment','left',...
   'fontweight','normal',...
   'fontsize',10,...
   'backgroundcolor',frc,...
   'position',[15 200 120 20],...
   'tooltipstring',tool,...  
   'style','text');


figure(1);
delete(findobj(get(1,'children'),'type','axes'));
h=axes('parent',1,'position',[0.3,0.11,0.685,0.815]);
if min(Ry)==1|fy<2,
   plot(err);
   ylabel('SSE');
   xlabel('nb PC for X');
else
   surf(err);
   zlabel('SSE');
   xlabel('nb PC for Y');
   ylabel('nb PC for X');
end;
