function [err,rx,ryvi] = choixcompvcacpVI2(Y,X,mi,mo,c);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% choixcompvcacpVI                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rxmax: maximal dimensions of the subspaces 
%             obtained by pca of X
%     ryvimax: maximal dimension of pca for PxY
%      cent=1 means centering (if not, 0 (default))
% OUTPUTS
%     err  error of prediction by cross validation 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes and       %
%   cross validation in order to estimate           %
%   the accurate of prediction                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regressvcacpVI                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   20/12/2001   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;

Rx=size(X);
Ry=size(Y);
algo=mi.options.algorithm.name;
fx=mi.nbfactors.max;
fy=mi.nbfactors.min;
opti=struct('tol',mi.options.algorithm.value,'maxit',mi.options.algorithm.maxiter,'disp',0);
if fx>min(Rx),
   uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Rx)),'.']}));
   return;
end;
if fy>min(Ry),
   uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Ry)),'.']}));
   return;
end;



err(1:mi.nbfactors.max,1:mi.nbfactors.min)=nan;
mo.validation.xfactors{1}=zeros(Rx(1)-1,fx,Rx(1));
mo.validation.xfactors{2}=zeros(Ry(1)-1,fx,Rx(1));
mo.validation.core=zeros(fx,fx,Rx(1));
mo.validation.xev=zeros(fx,Rx(1));
err=zeros(fx,fy,Rx(1));
for i=1:Rx(1),   % truncated X
   Xvc=X([1:i-1,i+1:Rx(1)],:);
   x=X(i,:);
   Yvc=Y([1:i-1,i+1:Rx(1)],:);
   y=Y(i,:);
   [Ux,Sx,Vx,mo.validation.xev(:,i)]=acpf(Xvc,fx,algo,opti);
	for k=1:fx,
      [PxYc,Bc]=regression2D(Yvc,Ux(:,1:k)*Sx(1:k,1:k));
   	[U,S,Vyvi,vexpvi]=acpf(PxYc,fy,algo,opti);
   	for j=1:fy,
         [ypred] = predicacpVI(x,Bc,Vyvi(:,1:j),Vx(:,1:k));
         err(k,j,i)=100*sum((ypred'-y).^2)/sum((y.^2));
      end;
   end;
end;
err=mean(err,3);

mainfig=findobj('userdata','Cubatch');
delete(findobj('tag','cbaxes'));
h=axes('parent',mainfig,'position',sizeaxes{1},'tag','cbaxes','nextplot','replacechildren');
set(0,'currentfigure',mainfig);
if min(Ry)==1|fy<2,
   plot(err);
   ylabel('SSE');
   xlabel('nb PC for X');
else
   surf(err);
   zlabel('SSE');
   xlabel('nb PC for Y');
   ylabel('nb PC for X');
end;
acpvidisplayInfo(mainfig,mi,mo);