function [xpred,fxpred,ypred,fypred] = acpvipredic(x,B,Byvi,Bx);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpvipredic                                        %
% [ypred] = acpvipredic(x,B,Byvi,Bx);                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     x :  p-vector
%     B:regression coefficient matrix (pq-matrix)
%     Byvi: loadings of PxY
%     Bx: loadings of X
% OUTPUTS
%     y predicted vector (q-vector)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Predicts a vector y with a regressed vector x    %
%  with PCA-IV                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regression2D                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   04/09/2002   version 1.2                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[m,mm]=size(x);
if isequal(m,1),
   x=x';
end;
%X size n*p, x size p*1

%projection de x sur col[Bx]
[xpred,fxpred]=regression2D(x,Bx);
  %x size (1*rx)


%prdiction de y (rgression multilinaire)
y=fxpred'*B;


% projection de y sur col(Byvi)
ypred=Byvi*inv(Byvi'*Byvi)*Byvi'*y';

[ypred,fypred]=regression2D(y',Byvi);









   