function acpviplot(typ,spl,mi,mo,c,d);
%  typ: 'gra','mod','exv','res','xmo'
%  spl for PlotStr structure
%  mi for ModelIn structure
%  mo for ModelOut structure
%  c for content object
%  d is the CBdataset object
%
%  Christophe Durville
guinames;
mainfig=findobj(0,'type','figure','userdata','Cubatch');
if nargin==6,
    if ndims(d{1})>2,   %  N-way data
        d{1}=unfoldcbdataset(d{1});
    end;
    if ndims(d{2})>2,   %  N-way data
        d{2}=unfoldcbdataset(d{2});
    end;
    X=d{1}.data;
    Y=d{2}.data;
    Rx=size(X);
    Ry=size(Y);
    Ny=length(Ry);
    if min(Ry)==1 & Ny==2,
        Ny=1;
    end;
    Nx=length(Rx);
end;
if strcmp(typ(1:3),'gra'),    %verification de non doublure
    h=findobj('tag','pcaviplot');
    if ~isempty(h),  %verification de non doublure
        delete(h);
    end;
    if strcmp(typ,'graY'),
        [mi,mo,spl]= checkp(mi,mo,spl);
        wp=['evalin(''caller'',''setappdata(',int2str(mainfig),',''''PlotStr'''',spl)'');acpviplot(''modY'',getappdata(',int2str(mainfig),',''PlotStr''),getappdata(',int2str(mainfig),',''Model''),getappdata(',int2str(mainfig),',''Results''),getappdata(',int2str(mainfig),',''Content''));'];
        nom=['Y data: Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
        for i=1:mi.nbfactors.min,
            stu{i}=['PC',int2str(i)];
        end;
        if isequal(spl.plotdims,1),
            stu{mi.nbfactors.min+1}='All';
        end;
    elseif strcmp(typ,'graX'),
        wp=['evalin(''caller'',''setappdata(',int2str(mainfig),',''''PlotStr'''',spl)'');acpviplot(''modX'',getappdata(',int2str(mainfig),',''PlotStr''),getappdata(',int2str(mainfig),',''Model''),getappdata(',int2str(mainfig),',''Results''),getappdata(',int2str(mainfig),',''Content''));'];
        nom=['X data: Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
        for i=1:mi.nbfactors.max,
            stu{i}=['PC',int2str(i)];
        end;
        if isequal(spl.plotdims,1),
            stu{mi.nbfactors.max+1}='All';
        end;
    end;   
    h0 = figure('MenuBar','none', ...
        'Name',nom, ...
        'MenuBar','none', ...
        'NumberTitle','off', ...
        'resize','off',...
        'Position',[50 300 320 320], ...
        'userdata','window',...
        'color',WIC,...
        'Tag','pcaviplot',...
        'toolbar','none');
    h1 = uimenu('Parent',h0, ...
        'Label','&Tools', ...
        'Tag','toolp');
    h2 = uimenu('Parent',h1, ...
        'Label','&Process control');
    if spl.plotdims==2|spl.plotdims==3,
        h3 = uimenu('Parent',h2, ...
            'enable','on',...
            'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.hotelling.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.hotelling.exist=1;'');end;',...
            'Label','&Hotelling''s T2');   
        if spl.additional.hotelling.exist==1,
            set(h3,'checked','on');
        end;
    end;
    if spl.plotdims==2,
        h3 = uimenu('Parent',h2, ...
            'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.potential.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.potential.exist=1;'');end;',...
            'tag','pot',...
            'Label','&Potential functions');
        if spl.additional.potential.exist==1,
            set(h3,'checked','on');
        end;
    end;
    h1 = uimenu('Parent',h0, ...
        'Label','&Preferences', ...
        'Tag','prefp');
    h2 = uimenu('Parent',h1, ...
        'Label','&Color');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','b',...
        'Label','&Blue');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','r',...
        'Label','&Red');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','g',...
        'Label','&Green');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','m',...
        'Label','&Magenta');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','c',...
        'Label','&Cyan');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','k',...
        'Label','&Black');
    set(findobj('tag',spl.color),'checked','on');
    h2 = uimenu('Parent',h1, ...
        'Label','&Marker');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','^',...
        'Label','Triangle');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','p',...
        'Label','Pentagram');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','d',...
        'Label','Diamond');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','*',...
        'Label','Star (*)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','o',...
        'Label','Circle (o)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','.',...
        'Label','Point (.)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','+',...
        'Label','Plus (+)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','none',...
        'Label','None');
    set(findobj('tag',spl.marker),'checked','on');
    h2 = uimenu('Parent',h1, ...
        'Label','&Line style');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','-',...
        'Label','Solid (-)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag',':',...
        'Label','Dotted (:)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','-.',...
        'Label','Dashdotted (-.)');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','--',...
        'Label','Dashed (--)');
    set(findobj('tag',spl.linestyle),'checked','on');
    h2 = uimenu('Parent',h1, ...
        'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')',...
        'tag','grid',...
        'separator','on',...
        'Label','&Grid');
    if strcmp(spl.grid,'on'),
        set(findobj('tag','grid'),'checked','on');
    end;
    if isequal(spl.plotdims,3),
        h2 = uimenu('Parent',h1, ...
            'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')',...
            'tag','shadow',...
            'Label','&Shadow');
        if isequal(spl.additional.shadow,1),
            set(findobj('tag','shadow'),'checked','on');
        end;
    end;
    h2 = uimenu('Parent',h1, ...
        'Label','&Visible', ...
        'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')',...
        'Tag','vispca');
    if strcmp(spl.visible,'on'),
        set(findobj('tag','vispca'),'checked','on');
    end;
    h2 = uimenu('Parent',h1, ...
        'Label','&Process control options', ...
        'separator','on',...
        'Tag','pco');
    h3 = uimenu('Parent',h2, ...
        'Label','&Hotelling''s T2 options', ...
        'callback','evalin(''caller'',''hotel(''''win'''',spl,mo);'');',...
        'Tag','ho');
    h3 = uimenu('Parent',h2, ...
        'Label','&Potential options', ...
        'callback','evalin(''caller'',''potentiel(''''win'''',spl,mo);'');',...
        'Tag','po');
    h1 = uimenu('Parent',h0, ...
        'Label','&Help', ...
        'Tag','helpacpviplot');
    h1=uicontrol('parent', h0,...
        'tag','clo',...
        'string','Close',...
        'callback','close(gcf);',...
        'fontsize',12,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[170 30 130 30],...
        'tooltipstring','close ',...  
        'style','pushbutton');  
    h1=uicontrol('parent', h0,...
        'tag','sta',...
        'string','OK',...
        'fontsize',12,...
        'callback',wp,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[10 30 130 30],...
        'tooltipstring','',...  
        'style','pushbutton');
    h1 = uicontrol('Parent',h0, ...
        'style','text',...
        'backgroundcolor',WIC,...
        'Position',[0 247 290 41]);
    h1=uicontrol('parent', h0,...   % frame options graphiques vi
        'backgroundcolor',FRC,...
        'position',[20 160 240 66],...
        'style','frame');
    if strcmp(typ,'graY'),
        a1=uicontrol('parent', h0,...
            'backgroundcolor',FRC,...
            'string','PCA (Y)',...
            'callback','evalin(''caller'',''spl.additional.plotvi(1)=mod(spl.additional.plotvi(1)+1,2);'');',...
            'position',[30 203 110 20],...
            'tooltipstring','Unconstrained',...
            'style','checkbox');
        a2=uicontrol('parent', h0,...
            'backgroundcolor',FRC,...
            'string','PCA (PxY)',...
            'tooltipstring','Constrained by the main subspaces of X.',...
            'callback','evalin(''caller'',''spl.additional.plotvi(2)=mod(spl.additional.plotvi(2)+1,2);'');',...
            'position',[30 183 110 20],...
            'style','checkbox');
        a3=uicontrol('parent', h0,...
            'backgroundcolor',FRC,...
            'tooltipstring',['Constrained by the orthogonal',char(10),'of the main subspaces of X.'],...
            'callback','evalin(''caller'',''spl.additional.plotvi(3)=mod(spl.additional.plotvi(3)+1,2);'');',...
            'string','PCA (QxY)',...
            'position',[30 163 110 20],...
            'style','checkbox');
        for i=1:3,
            if spl.additional.plotvi(i)==1,
                set(eval(['a',int2str(i)]),'value',1);
            end;
        end;
    end;
    
    
    h1=uicontrol('parent', h0,...
        'backgroundcolor',FRC,...
        'position',[20 110 240 30],...
        'style','frame');
    h1=uicontrol('parent', h0,...
        'string','Format:',...
        'fontsize',12,...
        'backgroundcolor',FRC,...
        'position',[25 114 60 20],...
        'style','text');
    h1=uicontrol('parent', h0,...
        'tag','aster',...
        'string',{'Integer','Label','Marker'},...
        'fontsize',12,...
        'value',spl.format(1),...
        'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');',...
        'backgroundcolor',LBC,...
        'position',[85 117 70 20],...
        'tooltipstring','',...  
        'style','popupmenu');
    h1=uicontrol('parent', h0,...
        'tag','condis',...
        'string',{'Continuous','Discrete'},...
        'value',spl.format(2),...
        'fontsize',12,...
        'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');',...
        'backgroundcolor',LBC,...
        'position',[160 117 90 20],...
        'tooltipstring','',...  
        'style','popupmenu');
    
    
    cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
    cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
    cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
    mini=min(mi.nbfactors.min);
    if spl.factors(1)>mini,
        spl.factors(1)=1;
    end;
    if spl.factors(2)>mini,
        spl.factors(2)=2;
    end;
    if spl.factors(3)>mini,
        spl.factors(3)=3;
    end;
    switch spl.plotdims,
        case 1
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'callback',cb1,...
                'Position',[120 230 50 50], ...
                'backgroundcolor',LBC,...
                'value',spl.factors(1),...
                'string',stu,...
                'Tag','1d1');
        case 2,     
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'Position',[70 230 50 50], ...
                'callback',cb1,...
                'value',spl.factors(1),...
                'backgroundcolor',LBC,...
                'string',stu,...
                'Tag','2d1');
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'Position',[170 230 50 50], ...
                'value',spl.factors(2),...
                'callback',cb2,...
                'backgroundcolor',LBC,...
                'string',stu,...
                'Tag','2d2');
            h1 = uicontrol('Parent',h0, ...
                'style','text',...
                'Position',[120 258 50 19], ...
                'backgroundcolor',WIC,...
                'string','versus',...
                'Tag','tool');
            
        case 3,
            
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'callback',cb1,...
                'Position',[30 230 50 50], ...
                'value',spl.factors(1),...
                'backgroundcolor',LBC,...
                'string',stu,...
                'Tag','3d1');
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'callback',cb2,...
                'Position',[130 230 50 50], ...
                'backgroundcolor',LBC,...
                'value',spl.factors(2),...
                'string',stu,...
                'Tag','3d2');
            h1 = uicontrol('Parent',h0, ...
                'style','popupmenu',...
                'callback',cb3,...
                'Position',[230 230 50 50], ...
                'backgroundcolor',LBC,...
                'value',spl.factors(3),...
                'string',stu,...
                'Tag','3d3');
            h1 = uicontrol('Parent',h0, ...
                'style','text',...
                'Position',[80 258 50 19], ...
                'string','versus',...
                'backgroundcolor',WIC,...
                'Tag','tool');
            h1 = uicontrol('Parent',h0, ...
                'style','text',...
                'Position',[180 258 50 19], ...
                'backgroundcolor',WIC,...
                'string','versus',...
                'Tag','tool');
    end;
    h=findobj('tag','pcaviplot');
    set(h,'waitstatus','open');
    waitfor(h,'waitstatus','close');      
    
    
    
else %    (graphiques)
    hfig=findobj('userdata','Cubatch');
    if ~isempty(spl),
        setcvdata(hfig,'PlotStr',spl);
    end;
    delete(findobj('tag','cbaxes'));
    set(0,'currentfigure',hfig);
    h=axes('parent',1,'position',sizeaxes{1},'nextplot','replacechildren','tag','cbaxes');
    switch typ  % different kinds of graphics
        case {'modY','modX'}  % 123-D plots
            nt=length(spl.batch);
            delete(findobj('tag','cbaxes'));
            nplot=sum(spl.additional.plotvi);
            m=zeros(1,nplot);
            if strcmp(typ,'modX'),
                nplot=1;
            end;
            if nplot==1
                m(1)=axes('parent',1,'position',sizeaxes{1},'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==2,
                m(1)=axes('parent',1,'position',sizeaxes{2}(1,:),'tag','cbaxes','nextplot','replacechildren');
                m(2)=axes('parent',1,'position',sizeaxes{2}(2,:),'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==3,,
                m(1)=axes('parent',1,'position',sizeaxes{4}(1,:),'tag','cbaxes','nextplot','replacechildren');
                m(2)=axes('parent',1,'position',sizeaxes{4}(2,:),'tag','cbaxes','nextplot','replacechildren');
                m(3)=axes('parent',1,'position',sizeaxes{4}(3,:),'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==0,
                uiwait(errordlg({'You have to choose at most one PCA in the checkboxes.'}));
                return;
            end;
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            if strcmp(typ,'modY'),
                AA{1}=mo.model.yfactors{1}{spl.nummode}*mo.model.corey{1};
                AA{2}=mo.model.yfactors{2}{spl.nummode}*mo.model.corey{2};
                AA{3}=mo.model.yfactors{3}{spl.nummode}*mo.model.corey{3};
                [a,b]=size(AA{1});
                np=0;
                A=cell(1,nplot);
                nom={'PCA(Y)','IV-PCA(Y)','Residual IV-PCA(Y)'};
                for i=1:3,
                    if spl.additional.plotvi(i)==1,
                        np=np+1;
                        A{np}=AA{i};
                        nommode{np}=nom{i};
                    end;
                end;
                dim=c{2}.dims;
                N=length(dim);
                if N==2,
                    lab=c{2}.labels{spl.nummode};
                    dim=c{2}.dims;
                elseif N>2,
                    d=getappdata(mainfig,'X');
                    if ndims(d{2})>2,   %  N-way data
                        d{2}=unfoldcbdataset(d{2});
                    end;
                    lab=d{2}.labels{spl.nummode}; 
                    dim=d{2}.dims;
                end;
                BB=mo.prediction.yfactors;
            elseif strcmp(typ,'modX'),
                A{1}=mo.model.xfactors{spl.nummode}*mo.model.core;
                [a,b]=size(A{1});
                nommode={'PCA(X)'};
                dim=c{1}.dims;
                N=length(dim);
                if N==2,
                    lab=c{1}.labels{spl.nummode};
                    dim=c{1}.dims;
                elseif N>2,
                    d=getappdata(mainfig,'X');
                    if ndims(d{1})>2,   %  N-way data
                        d{1}=unfoldcbdataset(d{1});
                    end;
                    lab=d{1}.labels{spl.nummode};
                    dim=d{1}.dims;
                    
                end;
                BB=mo.prediction.xfactors;
            end;
            for iii=1:nplot,   %3 plots
                set(1,'currentaxes',m(iii));
                switch spl.plotdims
                    case 1,   %1D
                        if  spl.factors(1)< b+1,
                            plot(A{iii}(:,spl.factors(1)),'tag','plo','color',spl.color,'parent',m(iii));
                        else
                            plot(A{iii},'tag','plo','parent',m(iii));
                        end;
                        switch spl.format(1),
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                if  spl.factors(1)< b+1,
                                    if length(spl.nummode)<2
                                        for i=1:a,
                                            text(i,A{iii}(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                        end;
                                    else % mixed modes
                                        for i=1:a2
                                            for j=1:a1,
                                                text(i,A{iii}((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                            end; 
                                        end;
                                    end;
                                else,   
                                    for j=1:b
                                        for i=1:a,
                                            text(i,A{iii}(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;
                                end;
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                if  spl.factors(1)< b+1,
                                    if length(spl.nummode)<2
                                        for i=1:a,
                                            text(i,A{iii}(i,spl.factors(1)),lab(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                        end;
                                    else % mixed modes
                                        for i=1:a2
                                            for j=1:a1,
                                                text(i,A{iii}((j-1)*a2+i,spl.factors(1)),lab(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                            end; 
                                        end;
                                    end;
                                else %All plots
                                    for j=1:b
                                        for i=1:a,
                                            text(i,A{iii}(i,j),lab(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;
                                end;
                            case 3 %marker
                        end;
                        hold on;   %  projection
                        if ~isempty(mo.prediction.data) & spl.nummode==1 &  strcmp(nommode{iii},'IV-PCA(Y)'),
                            try
                                d=size(mo.prediction.yfactors{1},1);
                                u=size(mo.model.yfactors{2}{1},1);
                                plot(u+1:u+d,BB{1}(:,spl.factors(1)),'b','tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;
                        elseif length(spl.nummode)==2,  
                        end;   
                        hold off;
                    case 2,  %plot 2D
                        if length(spl.nummode)<2,
                            plot(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),'color',spl.color,'tag','plo','parent',m(iii));
                        else
                            for j=1:a1,
                                plot(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                hold on;
                            end;
                        end;
                        spl.format(1);
                        switch spl.format(1)
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                for i=1:dim(spl.nummode),
                                    text(A{iii}(i,spl.factors(1)),A{iii}(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                end;
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                for i=1:dim(spl.nummode),
                                    text(A{iii}(i,spl.factors(1)),A{iii}(i,spl.factors(2)),lab(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                end;
                            case 3 %marker
                        end;
                        hold on;   %  projection
                        if ~isempty(mo.prediction.data) & spl.nummode==1 &  strcmp(nommode{iii},'IV-PCA(Y)'),
                            try
                                plot(BB{1}(:,spl.factors(1)),BB{1}(:,spl.factors(2)),'b*','tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;
                        end;   
                        hold off;
                    case 3,  %plot3D
                        set(gca,'view',[-37.5 30]);
                        if length(spl.nummode)<2,
                            plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',spl.color,'tag','plo','parent',m(iii));
                        else,
                            for j=1:a1,
                                plot3(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),A{iii}((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                hold on;
                            end;
                        end;
                        hold on;
                        switch spl.format(1)
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                for j=1:dim(spl.nummode),
                                    text(A{iii}(j,spl.factors(1)),A{iii}(j,spl.factors(2)),A{iii}(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                end;
                                
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                if length(spl.nummode)<2,
                                    for j=1:dim(spl.nummode),
                                        text(A{iii}(j,spl.factors(1)),A{iii}(j,spl.factors(2)),A{iii}(j,spl.factors(3)),lab(j),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                    end;
                                else
                                    for i=1:a2
                                        for j=1:a1,
                                            text(A{iii}((j-1)*a2+i,spl.factors(1)),A{iii}((j-1)*a2+i,spl.factors(2)),A{iii}((j-1)*a2+i,spl.factors(3)),lab(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;                  
                                end;
                            case 3 %marker
                                
                        end;
                        if ~isempty(mo.prediction.data) & spl.nummode==1 &  strcmp(nommode{iii},'IV-PCA(Y)'),
                            try
                                plot3(BB{1}(:,spl.factors(1)),BB{1}(:,spl.factors(2)),BB{1}(:,spl.factors(3)),'b*','tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;
                        end;   
                        hold off;
                        

                        if isequal(spl.additional.shadow, 1),
                            axe=axis;
                            plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                            plot3(A{iii}(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A{iii}(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                            plot3(axe(2)*ones(dim(spl.nummode),1),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                            plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',spl.color,'tag','plo','parent',m(iii));
                        end;
                        
                        hold off;
                end;
                if spl.format(1)==3,
                    set(findobj('tag','plo'),'marker',spl.marker);
                end;
                set(findobj('tag','plo'),'linestyle',spl.linestyle);
                
                switch spl.format(2)
                    case 2 %discrete
                        set(findobj('tag','plo'),'linestyle','none');
                    case 1% continuous
                        %set(findobj('tag','plo'),'marker','none');
                end;
                
                if strcmp(typ,'modY'),
                    exv=mo.model.yev{iii};
                else
                    exv=mo.model.xev;
                end;
                if length(spl.nummode)>1 |spl.factors(1)> b,
                    xl=['PC',int2str(spl.factors(1))];
                    if spl.factors(1)> b,
                        xl=['All PC'];
                    end;
                else
                    xl=['PC',int2str(spl.factors(1)),':',num2str(exv(spl.factors(1))),'%'];
                end;
                xlabel(xl,'tag','xlab','tag','enluminure');
                if spl.plotdims>1
                    if spl.factors(1)>b,
                        yl=['PC',int2str(spl.factors(2))];
                    else
                        yl=['PC',int2str(spl.factors(2)),':',num2str(exv(spl.factors(2))),'%'];
                    end;
                    ylabel(yl,'tag','ylab','tag','enluminure');
                    if spl.plotdims>2,
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            zl=['PC',int2str(spl.factors(3))];
                        else
                            zl=['PC',int2str(spl.factors(3)),':',num2str(exv(spl.factors(3))),'%'];
                        end;
                        zlabel(zl,'tag','zlab','tag','enluminure');
                    end;
                end;
                titre=[nommode{iii},': Mode ',int2str(spl.nummode)];
                title(titre,'parent',m(iii),'tag','enluminure');
                if isequal(nplot,3),
                    set(findobj('tag','enluminure'),'fontsize',7);
                end;
                set(m(iii),'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                if spl.additional.potential.exist==1 & spl.plotdims==2,
                    axi=axis;
                    hold on;
                    try 
                        potentiel('gra',spl,A{iii},axi);
                    catch
                        uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                    end;
                end;
                if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                    hold on;
                    try
                        hotel('gra',spl,A{iii});
                    catch
                        uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                    end;
                end;
                set(findobj('tag','plo'),'visible',spl.visible);
                set(findobj('tag','plo2'),'visible',spl.visible);
                hold off;
            end;  %  3 plots
        case 'xmoX',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Xm=mo.model.xfactors{1}*mo.model.core*mo.model.xfactors{2}';
            if min(size(Xm))==1,
                plot(Xm);
            else
                surf(Xm);
            end;
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title(['Modelisation of X']);
        case 'xmoY',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Ym=mo.model.yfactors{1}{1}*mo.model.corey{1}*mo.model.yfactors{1}{2}';
            if min(size(Ym))==1,
                plot(Ym);
            else
                surf(Ym);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Modelisation of Y']);
        case 'xmoPxY',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Yvim=mo.model.yfactors{2}{1}*mo.model.corey{2}*mo.model.yfactors{2}{2}';
            if min(size(Yvim))==1,
                plot(Yvim);
            else
                surf(Yvim);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Modelisation of PxY']);
        case 'xmoQxY',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Yviom=mo.model.yfactors{3}{1}*mo.model.corey{3}*mo.model.yfactors{3}{2}';
            if min(size(Yviom))==1,
                plot(Yviom);
            else
                surf(Yviom);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Modelisation of QxY']);
        case 'resX',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Xm=mo.model.xfactors{1}*mo.model.core*mo.model.xfactors{2}';
            E=X-Xm;
            if min(size(X))==1,
                plot(E);
            else
                surf(E);
            end;
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title(['Residuals of X']);
        case 'resY',
            delete(findobj('tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Ym=mo.model.yfactors{1}{1}*mo.model.corey{1}*mo.model.yfactors{1}{2}';
            E=Y-Ym;
            if min(size(Y))==1,
                plot(E);
            else
                surf(E);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Residuals of Y']);
        case 'resPxY',
            delete(findobj('type','axes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Yvim=mo.model.yfactors{2}{1}*mo.model.corey{2}*mo.model.yfactors{2}{2}';
            E=mo.model.ypred{1}-Yvim;
            if min(size(Y))==1,
                plot(E);
            else
                surf(E);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Residuals of PxY']);
        case 'resQxY',
            delete(findobj('type','axes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            Yviom=mo.model.yfactors{3}{1}*mo.model.corey{3}*mo.model.yfactors{3}{2}';
            E=mo.model.ypred{2}-Yviom;
            if min(size(Y))==1,
                plot(E);
            else
                surf(E);
            end;
            xlabel(c{2}.modenames{2});
            ylabel(c{2}.modenames{1});
            title(['Residuals of QxY']);
            
        case 'varori'
            if length(d{2}.labels{2})>1,
                [sel,ok]=listdlg('liststring',d{2}.labels{2},...
                    'name',['Variables of Y'],...
                    'selectionmode','multiple',...
                    'promptstring',['Choose between the variables of Y']);
            else
                ok=1;
                sel=1;
            end;
            if ok==1,
                Nsel=length(sel);
                Yvi=mo.model.yfactors{2}{1}*mo.model.corey{2}*mo.model.yfactors{2}{2}';
                for i=1:Nsel,
                    plot(Y(:,sel(i)),Yvi(:,sel(i)),'r+');
                    hold on;
                end;
                if ~isempty(mo.prediction.ypred),
                    try
                        plot(squeeze(mo.prediction.ypred(:,sel)),squeeze(mo.prediction.ypred(:,sel)),'b+');
                    catch
                        uiwait(errordlg({'error for the plot of projections',lasterr}))
                    end;
                    %elseif length(spl.nummode)==2,    
                end; 
                axe=axis;
                a=axe(1);
                b=axe(2);
                plot([a,b],[a,b],'b');
                % calcul du MAPE: sum |Yi-Yhati|/Yi
                
                ylabel('Predicted Y');
                xlabel('Original Y');
                if Nsel==1,
                    title([d{2}.labels{2}{sel}]);
                else
                    title([d{2}.labels{2}{sel(1)},'...',d{2}.labels{2}{sel(Nsel)}]);
                end;
            end;
        case 'lineoripred',
            N=2;
            if length(d{2}.labels{2})>1,
                for i=1:N-1,
                    [sel{i},ok(i)]=listdlg('liststring',d{2}.labels{2},...
                        'selectionmode','multiple',...
                        'promptstring',['Choose between the modalities:']);
                end;
            else
                ok=1;
                sel={1};
            end;
            if mean(ok)==1,
                N=size(Y,1);
                dn=size(mo.prediction.ypred);
                Yvi=mo.model.yfactors{2}{1}*mo.model.corey{2}*mo.model.yfactors{2}{2}';
                %h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
                plot(1:N,Y(:,sel{:}),'b');
                plot(Y(:,sel{:}),Yvi(:,sel{:}),'r+');
                axe=axis;
                hold on;
                plot(axe(1:2),axe(3:4),'b');
                if ~isempty(mo.prediction.ypred), %projection
                    try
                        plot([N+1:N+dn],mo.prediction.ypred(:,sel{:}),'r');
                    catch
                        uiwait(errordlg({'error for the plot of projections',lasterr}))
                    end;   
                end; 
                xlabel(d{2}.modenames{1});
                title([d{2}.labels{2}(sel{:})]);
            end;
        case 'exvX' % Explained variation
            delete(findobj(get(1,'children'),'tag','cbaxes'));
            h=axes('parent',1,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            barh(mo.model.xev);
            set(gca,'ydir','reverse');
            xlabel('Explained Variation (%)');
            ylabel('PC');
            title('PCA(X)');
        case 'exvY' % Explained variation
            delete(findobj(get(gcbf,'children'),'tag','cbaxes'));
            h=axes('parent',gcbf,'position',[0.3,0.11,0.685,0.815],'nextplot','replacechildren','tag','cbaxes');
            barh([mo.model.yev{1}',mo.model.yev{2}',mo.model.yev{3}']);
            set(gca,'ydir','reverse');
            xlabel('Explained Variation (%)');
            ylabel('PC');
            legend(h,'PCA(Y)','PCA(PxY)','PCA(QxY)',0);
    end;  %switch type
    hold off;
end;  %graphiques
end;
