function acpvidisplayInfo(mainfig,mi,mo);

GuiNames;

%X = mo.data.dataset;
X=getappdata(mainfig,'X');

delete(findobj(tg,'textfig'))
if ~isa(X,'cell')
   X = {X};
end
DisplayInfo(mainfig,X);
fnor = {'fontunits','normalized'};
vert = {'verticalalignment','cap'};
a    = findobj(tg,'textfig');
apos = get(a,'extent');
if isa(apos,'cell')
    apos = min(cat(1,apos{:}));
end
 if strcmp(mi.options.species,'met'), % def de valou (validation 1/model 0)
     valou=0;
 elseif strcmp(mi.options.species,'val'),
     valou=1;
 end;
if strcmp(mi.valmethod.name,'none'),
    ques='Model';
    S2a   = {'\fontsize{10}Algorithm';'N. of factors';'Expl. Var.';'Centering';'Scaling'};
else
    ques='Validation';
    S2a   = {'\fontsize{10}Validation';'Algorithm';'N. of factors';'Expl. Var.';'Centering';'Scaling'};
    switch mi.valmethod.name,
        case 'cv',
            methval='Cross-Validation';
    end;
end;
b     = text(.5,apos(2) - 0.05,['\bf\fontsize{12}',ques,': IV-PCA'],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
bpos  = get(b,'extent');
T2a   = {'Conv. Crit.';'Max. Iter.'};
%U2a   = {'Bootstrap'};
Alg =[mi.options.algorithm.name];

if length(mo.model) ~= 1
    NbFacStr = sprintf('%i - %i',mo.model(1).nbfactors,mo.model(end).nbfactors);
    EVStr    = [];
else
    NbFacStr = [int2str(mi.nbfactors.max),'x',int2str(mi.nbfactors.min)];
    EVStr    = [sprintf('%0.5g',sum(mo.model.yev{1})),'%'];  % global explained variation
 end
prcenx= [mi.sam(1).cen(1),mi.var(1).cen(:)'];
prscalx=[mi.sam(1).scal(1),mi.var(1).scal(:)'];
prceny= [mi.sam(1).cen(2),mi.var(2).cen(:)'];
prscaly=[mi.sam(1).scal(2),mi.var(2).scal(:)'];
 if ~isempty(prcenx)
   PreTrStrAx = [prceny(:)];
else
   PreTrStrAx=0;
end
if ~isempty(prscalx)
   PreTrStrBx = [prscaly(:)];
else
   PreTrStrBx=0;
end
 if ~isempty(prcenx)
   PreTrStrAy = [prceny(:)];
else
   PreTrStrAy=0;
end
if ~isempty(prscalx)
   PreTrStrBy = [prscaly(:)];
else
   PreTrStrBy=0;
end
Convcrit=mi.options.algorithm.value;
Maxiter=mi.options.algorithm.maxiter;
if strcmp(mi.valmethod.name,'none'),
    S2b = { [': ',Alg];...
            [': ',NbFacStr];...
            [': ',EVStr];...
            [': [ ',sprintf('%i ',PreTrStrAx),']x[',sprintf('%i ',PreTrStrAy),']'];...
            [': [ ',sprintf('%i ',PreTrStrBx),']x[',sprintf('%i ',PreTrStrBy),']']; };
else
    S2b = { [': ',methval];... 
            [': ',Alg];...
            [': ',NbFacStr];...
            [': ',EVStr];...
            [': [ ',sprintf('%i ',PreTrStrAx),']x[',sprintf('%i ',PreTrStrAy),']'];...
            [': [ ',sprintf('%i ',PreTrStrBx),']x[',sprintf('%i ',PreTrStrBy),']']; };
end;
T2b = { [': ',num2str(Convcrit)];...
        [': ',int2str(Maxiter)]};


if strcmp(Alg,'Nipals'),
   S2a = [S2a(:);T2a(:)];
   S2b = [S2b(:);T2b(:)];
end;


text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
cpos = get(c,'extent');S30 = [];

S3 = [];

if ~isempty(S30)
    d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
    dpos  = get(d,'extent');
    text(.05,dpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    e = text(.5,dpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
end

if ~isempty(mo.prediction.data)
    DisplayInfoProj(mainfig,mo,cpos);
end;
set(findobj(gcf,tg,'textfig'),'clipping','on')
