function [B,PxY,vexpvi,Ayvi,Byvi,vexpX,Ax,Bx] = acpVIf(Y,X,rx,ryvi,algo,opti);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpVIf                                              %
%[B,PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] =                %
%                      acpVIf(Y,X,rx,ryvi);           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rx: dimensions of the subspaces 
%             obtained by pca of X
%     ryvi: dimension of pca
%             for PxY
%     pro:2-vector corresponding to the 2 modes
%             1 if we want to project Y along the 
%                 corresponding mode.
%             0 if not.
% OUTPUTS
%     B regression coefficient matrix
%     PxY   the projected of Y on X.
%     vexpvi:Explained variation
%     Avi,Bvi:score and loadings of pca(PxY).
%     vexpX:  explained variation of X.
%     Ax,Bx:loadings of PCA(X).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes           % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    proj1gen                                       %
%    acp                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   18/12/2001   version 1.0                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[nx,px]=size(X);
[ny,py]=size(Y);
%erreur de format
if ~isequal(nx,ny) 
   error('X and Y must have the same number of lines');
end;




[U,S,Bx,vexpX] = acpf(X,rx,algo,opti);
Ax=U*S;
[PxY,B]=regression2D(Y,Ax);
[U,S,Byvi,vexpvi]=acpf(PxY,ryvi,algo,opti);
Ayvi=U*S;


   