function [ModelIn,ModelOut]=acpvi(ModelIn);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpvi                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     ModelIn structure
% OUTPUTS
%     ModelIn structure
%     ModelOut structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/11/2002    version 1.2                       %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
u=nargin;
mainfig=findobj(0,'type','figure','userdata','Cubatch');
guinames;
h=findobj('tag','acpvi');
if isempty(h),
    X=getappdata(mainfig,'X');
    if ndims(X{1})>2,   %  N-way data
        X{1}=unfoldcbdataset(X{1});
    end;
    if ndims(X{2})>2,   %  N-way data
        X{2}=unfoldcbdataset(X{2});
    end;
    modenames=X{1}.modenames;
    Nx=length(X{1}.dims);
    Ny=length(X{2}.dims);

    if X{2}.dims(2)==1,
        Ny=1;
    end;
   Rx=size(X{1}.data); 
   [ModelIn]=check(ModelIn);
   h0 = figure('MenuBar','none', ...
      'Name','IV-PCA', ...
      'NumberTitle','off', ...
      'Position',[400 300 360 280], ...
      'resize','off',...
      'userdata','window',...
      'color',WIC,...
      'Tag','acpvi',...
      'toolbar','none');
   h1 = uimenu('Parent',h0, ...
      'Label','&Preferences', ...
      'Tag','pref');
   if isempty(ModelIn.options.algorithm.name),
      ModelIn.options.algorithm.name='svd';
   end;
   if isempty(ModelIn.options.algorithm.maxiter),
      ModelIn.options.algorithm.maxiter=300;
   end;
   if isempty(ModelIn.options.algorithm.value),
      ModelIn.options.algorithm.value=1e-10;
   end;
   h2 = uimenu('Parent',h1, ...
      'Label','&Algorithms', ...
      'Tag','algo');
   h3 = uimenu('Parent',h2, ...
      'Callback','evalin(''caller'',''ModelIn.options.algorithm.name=''''nipals'''';set(gcbo,''''checked'''',''''on'''');set(findobj(''''tag'''',''''svd''''),''''checked'''',''''off'''');'');', ...
      'Label','&nipals', ...
      'Tag','nipals');
   h3 = uimenu('Parent',h2, ...
      'Callback','evalin(''caller'',''ModelIn.options.algorithm.name=''''svd'''';set(gcbo,''''checked'''',''''on'''');set(findobj(''''tag'''',''''nipals''''),''''checked'''',''''off'''');'');', ...
      'Label','&svd', ...
      'Tag','svd');
   if strcmp(ModelIn.options.algorithm.name,'nipals'),
      set(findobj('tag','nipals'),'checked','on');
      set(findobj('tag','svd'),'checked','off');
   elseif strcmp(ModelIn.options.algorithm.name,'svd'),
      set(findobj('tag','nipals'),'checked','off');
      set(findobj('tag','svd'),'checked','on');
   end;
   h2 = uimenu('Parent',h1, ...
      'Label','&Constraints', ...
      'Tag','const');
   h3 = uimenu('Parent',h2, ...
      'Callback','', ...
      'Label','No constraint', ...
      'checked','on',...
      'Tag','noconst');
   h2 = uimenu('Parent',h1, ...
      'separator','on',...
      'enable','off',...
      'Label','&Bootstrap');
   h3 = uimenu('Parent',h2, ...
      'Label','Bootstrap PCA');
   if isempty(ModelIn.valmethod.replicates),
      ModelIn.valmethod.replicates=5; %default values
   end;
   h3 = uimenu('Parent',h2, ...
      'callback','evalin(''caller'',''fnbboot(ModelIn.valmethod.replicates);'');',...
      'Label','Bootstrap replications');
   
   h1 = uimenu('Parent',h0, ...
      'Callback','', ...
      'Label','&Help', ...
      'Tag','help'); 
   ModelIn.valmethod.name='none';
   h1=uicontrol('parent', h0,...      % Frame validation
      'fontweight','normal',...
      'fontsize',10,...
      'backgroundcolor',FRC,...
      'tooltipstring','Validation window',...
      'position',[10 10 160 130],...
      'style','frame');
   h1=uicontrol('parent', h0,...      % validate
      'string','Validation',...
      'fontsize',12,...
      'callback','if get(gcbo,''value'')==1,set([findobj(''tag'',''croval'')],''enable'',''on'',''value'',1);evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');else set([findobj(''tag'',''booval1''),findobj(''tag'',''booval2''),findobj(''tag'',''croval'')],''enable'',''off'');evalin(''caller'',''ModelIn.valmethod.name=''''none'''';'');end;',...
      'backgroundcolor',FRC,...
      'position',[20 110 130 20],...
      'tooltipstring','Check only if You want to do a validation of IV-PCA.',...  
      'style','checkbox');
   h1=uicontrol('parent', h0,...      % cross validation
      'string','Cross-validation',...
      'fontsize',12,...
      'callback','evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');set([findobj(''tag'',''booval2''),findobj(''tag'',''booval1'')],''value'',0);set(gcbo,''value'',1);',...
      'tag','croval',...
      'value',1,...
      'backgroundcolor',FRC,...
      'enable','off',...
      'position',[35 90 130 20],...
      'tooltipstring','1 by 1 cross validation.',...  
      'style','radiobutton');
   h1=uicontrol('parent', h0,...      % bootstrap validation: naive
      'string','Naive bootstrap',...
      'enable','off',...
      'fontsize',12,...
      'callback','evalin(''caller'',''ModelIn.valmethod.name=''''nboo'''';'');set([findobj(''tag'',''booval2''),findobj(''tag'',''croval'')],''value'',0);',...
      'tag','booval1',...
      'value',0,...
      'backgroundcolor',FRC,...
      'position',[35 70 130 20],...
      'tooltipstring','Resample the rows of X.',...  
      'style','radiobutton');
   h1=uicontrol('parent', h0,...      % bootstrap validation: residual
      'string','Residual bootstrap',...
      'enable','off',...
      'fontsize',12,...
      'callback','evalin(''caller'',''ModelIn.valmethod.name=''''rboo'''';'');set([findobj(''tag'',''booval1''),findobj(''tag'',''croval'')],''value'',0);',...
      'tag','booval2',...
      'backgroundcolor',FRC,...
      'position',[35 50 134 20],...
      'tooltipstring','Resample the rows of the residuals of PCA(X).',...  
      'style','radiobutton');
   switch ModelIn.valmethod.name
   case 'nboo',
      set(findobj('tag','booval1'),'value',1);
   case 'rboo',
      set(findobj('tag','booval2'),'value',1);
   case 'cv'
      set(findobj('tag','croval'),'value',1);
   otherwise
      %ModelIn.valmethod.name='cv';
      %set(findobj('tag','croval'),'value',1);
   end;
   h1=uicontrol('parent', h0,...   %nbPC X text
      'string', 'Number PC X',...
      'fontweight','normal',...
      'fontsize',10,...
      'backgroundcolor',WIC,...
      'position',[0 235 110 20],...
      'style','text');
   h1=uicontrol('parent', h0,...   %nbPC Y text
      'string', 'Number PC Y',...
      'fontweight','normal',...
      'fontsize',10,...
      'backgroundcolor',WIC,...
      'position',[0 205 110 20],...
      'style','text');
   if isempty(ModelIn.nbfactors.max)|length(ModelIn.nbfactors.max)>1,
      ModelIn.nbfactors.max=6;
   end;
   h1=uicontrol('parent', h0,...     %nbPC X
      'string',ModelIn.nbfactors.max,...
      'callback','evalin(''caller'',''ModelIn.nbfactors.max=eval(get(gcbo,''''string''''));'');',...
      'fontweight','normal',...
      'fontsize',12,...
      'tag','npc',...
      'position',[110 235 40 20],...
      'style','edit');
   if isempty(ModelIn.nbfactors.min)|length(ModelIn.nbfactors.min)>1,
      ModelIn.nbfactors.min=3;
   end;
   if Ny==1,
       ModelIn.nbfactors.min=1;
   end;
   h1=uicontrol('parent', h0,...     %nbPC Y
      'string',ModelIn.nbfactors.min,...
      'callback','evalin(''caller'',''ModelIn.nbfactors.min=eval(get(gcbo,''''string''''));'');',...
      'fontweight','normal',...
      'fontsize',12,...
      'tag','npc',...
      'position',[110 205 40 20],...
      'style','edit');
    if Ny==1,
       set(h1,'style','text');
   end; 
   h1=uicontrol('parent', h0,...      %close button
      'string','Close',...
      'callback','close(gcf);',...
      'fontsize',12,...
      'backgroundcolor',[0.7 0.7 0.7],...
      'position',[200 10 130 30],...
      'tooltipstring','close "PCA"',...  
      'style','pushbutton');
   h1=uicontrol('parent', h0,...   %  PCA
      'tag','OKpca',...
      'string','OK',...
      'fontsize',12,...
      'callback','evalin(''caller'',''[ModelIn,ModelOut]=acpvi(ModelIn);'')',...
      'backgroundcolor',[0.7 0.7 0.7],...
      'position',[200 60 130 30],...
      'tooltipstring','Execute IV-PCA.',...  
      'style','pushbutton');  
   h1=uicontrol('parent', h0,...      %frame preprocess
      'fontweight','normal',...
      'fontsize',10,...
      'backgroundcolor',FRC,...
      'position',[190 140 160 130],...
      'tooltipstring','Preprocessing window',...
      'style','frame');
  if Ny==1, 
      cho=1;
  else
      cho=2;
  end;
   h1=uicontrol('parent', h0,...   %  preprocessing window
        'tag','prep',...
        'string','Preprocessing',...
        'fontsize',12,...
        'callback',['evalin(''caller'',''ModelIn=preprocess(ModelIn,',int2str(cho),');'');'],...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 230 130 30],...
        'tooltipstring','',...  
        'style','pushbutton');
   
else,
   [ModelOut,PlotStr] = DefineModelOut;
   X=getcvdata(mainfig,'X');
   if ndims(X{1})>2,   %  N-way data X
      X{1}=unfoldcbdataset(X{1});
   end;
   if ndims(X{2})>2,   %  N-way data X
      X{2}=unfoldcbdataset(X{2});
   end;   
   Y=X{2}.data;
   X=X{1}.data;
   Rxo=size(X);
   Ryo=size(Y);
   Nxo=ndims(X);
   Nyo=ndims(Y);   
   
   mcentx=[];
   mcenty=[];
   mscalx=[];
   mscaly=[];
   % preprocessing X
   if sum([ModelIn.sam(1).cen(1),ModelIn.var.cen,ModelIn.sam(1).scal(2),ModelIn.var(2).scal])>0, % X
       try
           [X,mcentx,mscalx]=nprocess(X,[ModelIn.sam(1).cen(1),ModelIn.var.cen],[ModelIn.sam(1).scal(1),ModelIn.var.scal]);
       catch
           uiwait(errordlg({'Error in the preprocessing part of X.',lasterr}));
       end;
   end;
   % preprocessing Y
   if sum([ModelIn.sam(1).cen(2),ModelIn.var(2).cen,ModelIn.sam(1).scal(1),ModelIn.var.scal])>0, % Y
       try
           [Y,mcenty,mscaly]=nprocess(Y,[ModelIn.sam(1).cen(2),ModelIn.var(2).cen],[ModelIn.sam(1).scal(2),ModelIn.var(2).scal]);
       catch
           uiwait(errordlg({'nouError in the preprocessing part of Y.',lasterr}));
       end;
   end;  
%    if isequal(ModelIn.sam.cen,1),% column-centering
%      mcentx=mean(X);
%      X=X-ones(Rx(1),1)*mcentx;
%      mcenty=mean(Y,1);
%      Y=Y-ones(Ry(1),1)*mcenty;
%    end;
%    if isequal(ModelIn.sam.scal,1),% column-scaling
%       mscalx=sqrt(mean(X.^2,1));
%       mscaly=sqrt(mean(Y.^2,1));
%       X=X./(ones(Rx(1),1)*sqrt(mean(X.^2,1)));%georges 8/08/2002
%       Y=Y./(ones(Ry(1),1)*sqrt(mean(Y.^2,1)));%georges 8/08/2002
%    end;
   
   if strcmp(ModelIn.valmethod.name,'nboo'),
      ModelOut.validation.stats.risk=bootcompacpvi(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'n');      
   elseif strcmp(ModelIn.valmethod.name,'rboo'),
      ModelOut.validation.stats.risk=bootcompacpvi(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'r');
   elseif strcmp(ModelIn.valmethod.name,'cv'),
      %[ModelOut.validation.stats.risk,rx,ryvi] = 
      choixcompvcacpVI2(Y,X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'));
   elseif strcmp(ModelIn.valmethod.name,'none'),
      Rx=size(X);
      Ry=size(Y);
      if min(Rx)==1,
          Nx=1;
      else 
          Nx=2;
      end;
      if min(Ry)==1,
          Ny=1;
      else 
          Ny=2;
       end;
      mcent=[];
      fx=ModelIn.nbfactors.max;
      if fx>min(Rx),
         uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Rx)),'.']}));
         return;
      end;
      fy=ModelIn.nbfactors.min;
      if fy>min(Ry),
         uiwait(errordlg({'Error. The number of components for Y',['has to be inferior to ' int2str(min(Ry)),'.']}));
         return;
      end;

      
      % PCA X step
      Fx=cell(1,2);
      if strcmp(ModelIn.options.algorithm.name,'svd'),
         [Fx{1} Sx Fx{2}]=svd(X,0);
         if fx<min(size(X)),
            Fx{1}=Fx{1}(:,1:fx);
            Sx=Sx(1:fx,1:fx);
            Fx{2}=Fx{2}(:,1:fx);
         end;
      elseif strcmp(ModelIn.options.algorithm.name,'nipals'),
         options.tol=ModelIn.options.algorithm.value;
         options.maxit=ModelIn.options.algorithm.maxiter;
         [Fx{1} Sx Fx{2} Model]=svds(X,fx,'L',options);
      end;
      for i=1:fx,
         Xi=Fx{1}(:,i)*Sx(i,i)*Fx{2}(:,i)';
         vexpX(i)=100*sum(Xi(:).^2)/misssum(X(:).^2);
      end;
      
      % regression step
      [PxY,B]=regression2D(Y,Fx{1}*Sx);
      
      
      VPxY=100*sum(PxY(:).^2)/sum(Y(:).^2);
      QxY=Y-PxY;
      VQxY=100*sum(QxY(:).^2)/sum(Y(:).^2);
      
      % PCVA Y step
      if strcmp(ModelIn.options.algorithm.name,'svd'),
         [Fy{1} Sy Fy{2}]=svd(Y,0);
         if fy<min(size(PxY)),
            Fy{1}=Fy{1}(:,1:fy);
            Sy=Sy(1:fy,1:fy);
            Fy{2}=Fy{2}(:,1:fy);
         end;
      elseif strcmp(ModelIn.options.algorithm.name,'nipals'),
         options.tol=ModelIn.options.algorithm.value;
         options.maxit=ModelIn.options.algorithm.maxiter;
         [Fy{1} Sy Fy{2} Model]=svds(PxY,fy,'L',options);
      end; 
      for i=1:fy,
         Yi=Fy{1}(:,i)*Sy(i,i)*Fy{2}(:,i)';
         vexpY(i)=100*sum(Yi(:).^2)/misssum(Y(:).^2);
      end; 
      
      % PCVA Yvi step
      if strcmp(ModelIn.options.algorithm.name,'svd'),
         [Fyvi{1} Syvi Fyvi{2}]=svd(PxY,0);
         if fy<min(size(PxY)),
            Fyvi{1}=Fyvi{1}(:,1:fy);
            Syvi=Syvi(1:fy,1:fy);
            Fyvi{2}=Fyvi{2}(:,1:fy);
         end;
      elseif strcmp(ModelIn.options.algorithm.name,'nipals'),
         options.tol=ModelIn.options.algorithm.value;
         options.maxit=ModelIn.options.algorithm.maxiter;
         [Fyvi{1} Syvi Fyvi{2} Model]=svds(PxY,fy,'L',options);
      end; 
      for i=1:fy,
         Yi=Fyvi{1}(:,i)*Syvi(i,i)*Fyvi{2}(:,i)';
         vexpYvi(i)=100*sum(Yi(:).^2)/misssum(PxY(:).^2);
      end;
      
     % PCVA Yvio step
      if strcmp(ModelIn.options.algorithm.name,'svd'),
         [Fyvio{1} Syvio Fyvio{2}]=svd(QxY,0);
         if fy<min(size(PxY)),
            Fyvio{1}=Fyvio{1}(:,1:fy);
            Syvio=Syvio(1:fy,1:fy);
            Fyvio{2}=Fyvio{2}(:,1:fy);
         end;
      elseif strcmp(ModelIn.options.algorithm.name,'nipals'),
         options.tol=ModelIn.options.algorithm.value;
         options.maxit=ModelIn.options.algorithm.maxiter;
         [Fyvio{1} Syvio Fyvio{2} Model]=svds(PxY,fy,'L',options);
      end; 
      for i=1:fy,
         QxYi=Fyvio{1}(:,i)*Syvio(i,i)*Fyvio{2}(:,i)';
         vexpYvio(i)=100*sum(QxYi(:).^2)/misssum(QxY(:).^2);
      end;
           
      
          
      %construction du uimenu Exploitation
      set(findobj('tag','pred'),'enable','off');
      set(findobj('tag','proj'),'enable','on');
      set(findobj('tag','proj'),'callback','strpca=cdprojpred(''pca'',u,strpca,cx,d.dims);');
      
      close(gcf);
      
      
      
      % ModelOut implementation
      ModelOut.model.xfactors=cell(1,2);
      ModelOut.model.xfactors=Fx;
      ModelOut.model.core=Sx;
      ModelOut.model.yfactors={Fy,Fyvi,Fyvio};
      ModelOut.model.corey={Sy,Syvi,Syvio};
      ModelOut.model.xev=vexpX;
      ModelOut.model.yev={vexpY,vexpYvi,vexpYvio};
      ModelOut.model.nbfactors=ModelIn.nbfactors;
      ModelOut.modelname='IV-PCA';
      ModelOut.model.ypred={PxY,QxY};
      ModelOut.model.bcoeff=B;
      ModelOut.model.xpress=cell(2,1);
      ModelOut.model.xpress{1}=VPxY;
      ModelOut.model.xpress{2}=VQxY;
      ModelOut.model(1).xpreproc.cen= mcentx;
      ModelOut.model(1).xpreproc.scal=mscalx;
      ModelOut.model(1).ypreproc.cen= mcenty;
      ModelOut.model(1).ypreproc.scal=mscaly;
           
      % default plot installation
      defaultplot(ModelIn,ModelOut);
   end;%IV-PCA model (opposite to validation)   
   
end;%IV-pca execution




