function [Ab,Bb,SS] = residuelacp(E,A,B);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residuelacp                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   E  residuals of a pca
%   A,B scores and loadings of the pca
% OUTPUTS
%   Ab , Bb: bootstrap scores and loadings 
%   SS diagonal matrix with 
%        singular values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pca on bootstrap data Xb=A*B'+Eb                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



[n,f]=size(A);
[p,f]=size(B);

Xmod=A*B';
[n p]=size(Xmod);

Xb=E+Xmod;

[U S V]=svd(Xb,0);
U=U(:,1:f);
S=S(1:f,1:f);
SS = diag(S);
Bb=V(:,1:f);
Ab=U*S;


