%#
%# [S,V,D,Xpredicted]=msvdcv(X,center,maxfn,conv,maxiter)
%#
%# AIM: 			svd(X) with missing data and cross-validation
%# INPUT:			X (m x n) - data matrix
%# 					center=1 - data centering
%#					optional: maxfn - maximal number of factors
%#								 conv - convergence criterion
%#								 maxiter - maximal number of iterations
%# OUTPUT:		S,V,D;  X = S*D'; S=S*V;
%#					Xpredicted - data matrix with filled in elements
%#
%# AUTHOR:		Beata Walczak
%#
%# DATE:			version 1; 27.10.2000
%#

function [S,V,D,Xpredicted]=msvdcv(X,center,maxfn,conv,maxiter)

[m,n]=size(X);
if nargin<3
   maxfn=min(m,n)-1;
	conv=1e-10;
	maxiter=1000;
end
Mindex=find(isnan(X));		% find missing elements of X
res=zeros(m,maxfn);
% start
for fn=1:maxfn
      [S,V,D,Xp]=msvd(X,fn,center,conv,maxiter);
      for i=1:m				% cross-validation
   	  	ob=Xp(i,:);
     		r=Xp;r(i,:)=[];
	     	[s,v,d]=svd2(r);
	     	s=s*v;s=s(:,1:fn);
   	  	sp=ob*d(:,1:fn);
	     	obp=sp*d(:,1:fn)';
	     	res(i,fn)=sum((ob-obp).^2);
	   end %i    
end % for fn
ress=sum(res);
subplot(221);plot(ress);xlabel('factors');ylabel('SS');figure(gcf);pause

[i1 fn]=min(ress); 
fn=input('number of factors :   ');
[S,V,D,Xp]=msvd(X,fn,center,conv,maxiter);
