%#
%# [S,V,D,Xpredicted]=msvd(X,fn,center,conv,maxiter)
%#
%# AIM: 			svd(X) with missing data
%#
%# INPUT:			X (m x n) - data matrix with m objects and n variables
%#					fn - number of factors
%#					center - if center=1 - perform data centering
%#					otional:				
%#					conv    - convergence criterion (optional)
%# 					maxiter - maximal number of iterations (optional)
%#
%# OUTPUT:		S,V,D;  X = S*D', S=S*V;
%#					Xpredicted - data matrix reconstructed with fn factors
%# 
%# Subroutines: inimiss.m
%#
%# AUTHOR:		
% Beata Walczak
% ChemoAC, V.U.B., Laarbeeklaan 103, 
% B-1090 Brussel 
% Belgium 
%#
%# DATE:			version 1; 27.10.2000
%#

function [S,V,D,Xpredicted]=msvd(X,fn,center,conv,maxiter)

[m,n]=size(X);
if nargin<4
   conv=1e-10;
	maxiter=1000;
end
Mindex=find(isnan(X));						% find missing elements of X
% if length(Mindex)==0,						% no missing data
%    if center==1
%       Xc=X-ones(m,1)*mean(X);else,Xc=X;
%    end    
%    [S,V,D]=svd2(Xc);S=S*V;S=S(:,1:fn);D=D(:,1:fn);
%    Xpredicted=S*D'+ones(m,1)*mean(X);
%  else												% missing data
   [X]=inimiss(X);    						% initialization
   mx=mean(X);
	SS=sum(sum(X(Mindex).^2 ));
   f=2*conv;   iter=1;
   
   while iter<maxiter & f>conv, 
      SSold=SS;
      if center==1
         mx=mean(X);							% update data mean
         Xc=X-ones(m,1)*mx; else,  Xc=X;
      end
      [S,V,D]=svd2(Xc,0);
      S=S*V;S=S(:,1:fn);D=D(:,1:fn);
      Xpredicted=S*D';
      if center==1
         Xpredicted=Xpredicted+ones(m,1)*mx;
      end   
      X(Mindex)=Xpredicted(Mindex);	% replace missing elements with new estimates
      SS=sum(sum(X(Mindex).^2));
      f=abs(SS-SSold)/SSold;
      iter=iter+1;
   end;
% end;
