%#
%#   function [X]=inimiss(X)
%#
%#   AIM:		substitution of missing elements by the means of variables
%#   INPUT:	data matrix X (objects x variables) with missing elements
%#   OUTPUT:	data matrix X with initial estimates of missing elements
%#
%# AUTHOR:		Beata Walczak
%#
%# DATE:			version 1; 27.10.2000
%#

function [X]=inimiss(X)

[m,n]=size(X);
mis=isnan(X);
[ii]=find(isnan(X));[i j]=find(isnan(X));
X(ii)=0;
meanc=sum(X)./(m-sum(mis));
meanr=sum(X')./(n-sum(mis'));
for k=1:length(i),
    X(i(k),j(k))=(meanr(i(k))+meanc(j(k)))/2;
end;


