function [Ab,Bb,SS] = naifacp(X,f);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% naifacp                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   X  data
%   f number of components
% OUTPUTS
%   Ab , Bb: scores and loadings of Xb bootstrapped 
%            from X
%   SS diagonal matrix with 
%        singular values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pca on bootstrap data of X  ( naive bootstrap)    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[U S V]=svd(X,0);
U=U(:,1:f);
S=S(1:f,1:f);
SS = diag(S);
Bb=V(:,1:f);
Ab=U*S;


